/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.ScenarioActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.AfterHookType;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioCall;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioOutlineResult;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.StepRuntime;
import com.intuit.karate.core.Tags;
import com.intuit.karate.core.Variable;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.shell.StringLogAppender;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScenarioRuntime
implements Runnable {
    public static final String EXPECT_TEST_TO_FAIL_BECAUSE_OF_FAIL_TAG = "Expect test to fail because of @fail tag";
    public final Logger logger = new Logger();
    public final FeatureRuntime featureRuntime;
    public final ScenarioCall caller;
    public final Scenario scenario;
    public final Tags tags;
    public final ScenarioActions actions;
    public final ScenarioResult result;
    public final ScenarioOutlineResult outlineResult;
    public final ScenarioEngine engine;
    public final boolean reportDisabled;
    public final Map<String, Object> magicVariables;
    public final boolean selectedForExecution;
    public final boolean perfMode;
    public final boolean dryRun;
    public final LogAppender logAppender;
    private boolean skipBackground;
    private boolean ignoringFailureSteps;
    private List<FeatureResult> callResults;
    private List<Step> steps;
    private List<Embed> embeds;
    private StepResult currentStepResult;
    private Step currentStep;
    private Throwable error;
    private boolean configFailed;
    private boolean skipped;
    private boolean stopped;
    private boolean aborted;
    private int stepIndex;

    public ScenarioRuntime(FeatureRuntime featureRuntime, Scenario scenario) {
        this.featureRuntime = featureRuntime;
        this.caller = featureRuntime.caller;
        boolean bl = this.perfMode = featureRuntime.perfHook != null;
        if (this.caller.isNone()) {
            this.logAppender = new StringLogAppender(false);
            this.engine = new ScenarioEngine(this.caller.getParentConfig(false), this, new HashMap<String, Variable>(), this.logger);
        } else if (this.caller.isSharedScope()) {
            this.logAppender = this.caller.parentRuntime.logAppender;
            this.engine = new ScenarioEngine(this.caller.getParentConfig(false), this, this.caller.getParentVars(false), this.logger);
        } else {
            this.logAppender = this.caller.parentRuntime.logAppender;
            this.engine = new ScenarioEngine(this.caller.getParentConfig(true), this, new HashMap<String, Variable>(), this.logger);
        }
        this.logger.setAppender(this.logAppender);
        this.actions = new ScenarioActions(this.engine);
        this.scenario = scenario;
        if (scenario.isDynamic() && !scenario.isOutlineExample()) {
            this.steps = Collections.emptyList();
            this.skipped = true;
            this.magicVariables = Collections.emptyMap();
        } else {
            this.magicVariables = this.initMagicVariables();
        }
        this.result = new ScenarioResult(scenario);
        this.outlineResult = new ScenarioOutlineResult(scenario.getSection().getScenarioOutline(), this);
        if (featureRuntime.setupResult != null) {
            StepResult sr = this.result.addFakeStepResult("@setup", null);
            ArrayList<FeatureResult> list = new ArrayList<FeatureResult>(1);
            FeatureResult fr = new FeatureResult(featureRuntime.featureCall.feature);
            fr.setCallDepth(1);
            fr.addResult(featureRuntime.setupResult);
            list.add(fr);
            sr.addCallResults(list);
            featureRuntime.setupResult = null;
        }
        this.dryRun = featureRuntime.suite.dryRun;
        this.tags = scenario.getTagsEffective();
        this.reportDisabled = this.perfMode ? true : this.tags.valuesFor("report").isAnyOf("false");
        this.selectedForExecution = ScenarioRuntime.isSelectedForExecution(featureRuntime, scenario, this.tags);
    }

    private Map<String, Object> initMagicVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.caller.isNone()) {
            if (!this.caller.isSharedScope()) {
                Map<String, Variable> copy = this.caller.getParentVars(true);
                copy.forEach((k, v) -> map.put((String)k, v.getValue()));
            }
            map.putAll(this.caller.parentRuntime.magicVariables);
            map.put("__arg", this.caller.arg == null ? null : (Object)this.caller.arg.getValue());
            map.put("__loop", this.caller.getLoopIndex());
        }
        if (this.scenario.isOutlineExample()) {
            Map<String, Object> exampleData = this.scenario.getExampleData();
            map.putAll(exampleData);
            map.put("__row", exampleData);
            map.put("__num", this.scenario.getExampleIndex());
        }
        return map;
    }

    public boolean isFailed() {
        return this.error != null || this.result.isFailed();
    }

    public Step getCurrentStep() {
        return this.currentStep;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isSkipBackground() {
        return this.skipBackground;
    }

    public void setSkipBackground(boolean skipBackground) {
        this.skipBackground = skipBackground;
    }

    public String getEmbedFileName(ResourceType resourceType) {
        String extension = resourceType == null ? null : resourceType.getExtension();
        return this.scenario.getUniqueId() + "_" + System.currentTimeMillis() + (String)(extension == null ? "" : "." + extension);
    }

    private Embed saveToFileAndCreateEmbed(byte[] bytes, ResourceType resourceType) {
        File file = new File(this.featureRuntime.suite.reportDir + File.separator + this.getEmbedFileName(resourceType));
        FileUtils.writeToFile(file, bytes);
        return new Embed(file, resourceType);
    }

    public Embed embed(byte[] bytes, ResourceType resourceType) {
        if (this.embeds == null) {
            this.embeds = new ArrayList<Embed>();
        }
        Embed embed = this.saveToFileAndCreateEmbed(bytes, resourceType);
        this.embeds.add(embed);
        return embed;
    }

    public Embed embedVideo(File file) {
        StepResult stepResult = this.result.addFakeStepResult("[video]", null);
        Embed embed = this.saveToFileAndCreateEmbed(FileUtils.toBytes(file), ResourceType.MP4);
        stepResult.addEmbed(embed);
        return embed;
    }

    public void addCallResult(FeatureResult fr) {
        if (this.callResults == null) {
            this.callResults = new ArrayList<FeatureResult>();
        }
        this.callResults.add(fr);
    }

    public LogAppender getLogAppender() {
        return this.logAppender;
    }

    public void stepBack() {
        this.stopped = false;
        this.stepIndex -= 2;
        if (this.stepIndex < 0) {
            this.stepIndex = 0;
        }
    }

    public void stepReset() {
        this.stopped = false;
        --this.stepIndex;
        if (this.stepIndex < 0) {
            this.stepIndex = 0;
        }
    }

    public void stepProceed() {
        this.stopped = false;
    }

    private int nextStepIndex() {
        return this.stepIndex++;
    }

    public Result evalAsStep(String expression) {
        Step evalStep = new Step(this.scenario, -1);
        try {
            evalStep.parseAndUpdateFrom(expression);
        }
        catch (Exception e) {
            return Result.failed(System.currentTimeMillis(), 0L, e, evalStep);
        }
        return StepRuntime.execute(evalStep, this.actions);
    }

    public boolean hotReload() {
        boolean success = false;
        Feature feature = this.scenario.getFeature();
        feature = Feature.read(feature.getResource());
        for (Step oldStep : this.steps) {
            String newText;
            String oldText;
            Step newStep = feature.findStepByLine(oldStep.getLine());
            if (newStep == null || (oldText = oldStep.getText()).equals(newText = newStep.getText())) continue;
            try {
                oldStep.parseAndUpdateFrom(newStep.getText());
                this.logger.info("hot reloaded line: {} - {}", newStep.getLine(), newStep.getText());
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("failed to hot reload step: {}", e.getMessage());
            }
        }
        return success;
    }

    public Map<String, Object> getScenarioInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>(5);
        File featureFile = this.featureRuntime.featureCall.feature.getResource().getFile();
        if (featureFile != null) {
            info.put("featureDir", featureFile.getParent());
            info.put("featureFileName", featureFile.getName());
        }
        info.put("scenarioName", this.scenario.getName());
        info.put("scenarioDescription", this.scenario.getDescription());
        String errorMessage = this.error == null ? null : this.error.getMessage();
        info.put("errorMessage", errorMessage);
        return info;
    }

    protected void logError(String message) {
        if (this.currentStep != null) {
            message = this.currentStep.getDebugInfo() + "\n" + this.currentStep.toString() + "\n" + (String)message;
        }
        this.logger.error("{}", message);
    }

    private void evalConfigJs(String js, String displayName) {
        if (js == null || this.configFailed) {
            return;
        }
        try {
            Variable fun = this.engine.evalJs("(" + js + ")");
            if (!fun.isJsFunction()) {
                this.logger.warn("not a valid js function: {}", displayName);
                return;
            }
            Map<String, Object> map = this.engine.getOrEvalAsMap(fun, new Object[0]);
            this.engine.setVariables(map);
        }
        catch (Exception e) {
            String message = ">> " + this.scenario.getDebugInfo() + "\n>> " + displayName + " failed\n>> " + e.getMessage();
            this.error = JsEngine.fromJsEvalException(js, e, message);
            this.stopped = true;
            this.configFailed = true;
        }
    }

    private static boolean isSelectedForExecution(FeatureRuntime fr, Scenario scenario, Tags tags) {
        org.slf4j.Logger logger = FeatureRuntime.logger;
        int callLine = fr.featureCall.callLine;
        if (callLine != -1) {
            int sectionLine = scenario.getSection().getLine();
            int scenarioLine = scenario.getLine();
            if (callLine == sectionLine || callLine == scenarioLine) {
                logger.info("found scenario at line: {}", (Object)callLine);
                return true;
            }
            logger.trace("skipping scenario at line: {}, needed: {}", (Object)scenario.getLine(), (Object)callLine);
            return false;
        }
        String callName = fr.featureCall.callName;
        if (callName != null) {
            if (scenario.getName().matches(callName)) {
                logger.info("found scenario at line: {} - {}", (Object)scenario.getLine(), (Object)callName);
                return true;
            }
            logger.trace("skipping scenario at line: {} - {}, needed: {}", new Object[]{scenario.getLine(), scenario.getName(), callName});
            return false;
        }
        String callTag = fr.featureCall.callTag;
        if (callTag != null) {
            if (tags.contains(callTag)) {
                logger.info("{} - call by tag at line {}: {}", new Object[]{fr, scenario.getLine(), callTag});
                return true;
            }
            logger.trace("skipping scenario at line: {} with call by tag effective: {}", (Object)scenario.getLine(), (Object)callTag);
            return false;
        }
        if (fr.caller.isNone()) {
            if (tags.evaluate(fr.suite.tagSelector, fr.suite.env)) {
                logger.trace("matched scenario at line: {} with tags effective: {}", (Object)scenario.getLine(), tags.getTags());
                return true;
            }
            logger.trace("skipping scenario at line: {} with tags effective: {}", (Object)scenario.getLine(), tags.getTags());
            return false;
        }
        return true;
    }

    public void beforeRun() {
        if (this.featureRuntime.caller.isNone() && this.featureRuntime.suite.isAborted()) {
            this.skipped = true;
            return;
        }
        this.steps = this.skipBackground ? this.scenario.getSteps() : this.scenario.getStepsIncludingBackground();
        ScenarioEngine.set(this.engine);
        this.engine.init();
        this.result.setExecutorName(Thread.currentThread().getName());
        this.result.setStartTime(System.currentTimeMillis());
        if (!this.dryRun) {
            if (this.caller.isNone() && !this.caller.isKarateConfigDisabled()) {
                this.evalConfigJs(this.featureRuntime.suite.karateBase, "karate-base.js");
                this.evalConfigJs(this.featureRuntime.suite.karateConfig, "karate-config.js");
                this.evalConfigJs(this.featureRuntime.suite.karateConfigEnv, "karate-config-" + this.featureRuntime.suite.env + ".js");
            }
            boolean bl = this.skipped = this.featureRuntime.suite.hooks.stream().map(h -> h.beforeScenario(this)).reduce(Boolean.TRUE, Boolean::logicalAnd) == false;
            if (this.skipped) {
                this.logger.debug("beforeScenario hook returned false, will skip scenario: {}", this.scenario);
            } else {
                this.evaluateScenarioName();
            }
        }
    }

    @Override
    public void run() {
        try {
            if (this.steps == null) {
                this.beforeRun();
            }
            if (this.skipped) {
                return;
            }
            int count = this.steps.size();
            int index = 0;
            while ((index = this.nextStepIndex()) < count) {
                this.currentStep = this.steps.get(index);
                this.execute(this.currentStep);
                if (this.currentStepResult == null) continue;
                this.result.addStepResult(this.currentStepResult);
            }
        }
        catch (Exception e) {
            if (this.currentStepResult != null) {
                this.result.addStepResult(this.currentStepResult);
            }
            this.logError("scenario [run] failed\n" + StringUtils.throwableToString(e));
            this.currentStepResult = this.result.addFakeStepResult("scenario [run] failed", e);
        }
        finally {
            if (!this.skipped) {
                this.afterRun();
                if (this.isFailed() && this.engine.getConfig().isAbortSuiteOnFailure()) {
                    this.featureRuntime.suite.abort();
                }
            }
            if (this.caller.isNone()) {
                this.logAppender.close();
            }
        }
    }

    public StepResult execute(Step step) {
        boolean executed;
        if (!this.stopped && !this.dryRun) {
            boolean shouldExecute = true;
            for (RuntimeHook hook : this.featureRuntime.suite.hooks) {
                if (hook.beforeStep(step, this)) continue;
                shouldExecute = false;
            }
            if (!shouldExecute) {
                return null;
            }
        }
        boolean bl = executed = !this.stopped;
        Result stepResult = this.stopped ? (this.aborted && this.engine.getConfig().isAbortedStepsShouldPass() ? Result.passed(System.currentTimeMillis(), 0L) : (this.configFailed ? Result.failed(System.currentTimeMillis(), 0L, this.error, step) : Result.skipped(System.currentTimeMillis()))) : (this.dryRun && !step.isSetup() ? Result.passed(System.currentTimeMillis(), 0L) : StepRuntime.execute(step, this.actions));
        this.currentStepResult = new StepResult(step, stepResult);
        if (stepResult.isAborted()) {
            this.aborted = true;
            this.stopped = true;
            this.logger.debug("abort at {}", step.getDebugInfo());
        } else if (stepResult.isFailed()) {
            if (stepResult.getMatchingMethod() != null && this.engine.getConfig().getContinueOnStepFailureMethods().contains(stepResult.getMatchingMethod().method)) {
                this.stopped = false;
                this.ignoringFailureSteps = true;
                this.currentStepResult.setErrorIgnored(true);
            } else {
                this.stopped = true;
            }
            if (!(!this.stopped || this.engine.getConfig().isContinueAfterContinueOnStepFailure() && this.engine.isIgnoringStepErrors())) {
                this.error = stepResult.getError();
                this.logError(this.error.getMessage());
            }
            if (this.engine.driver != null) {
                this.engine.driver.onFailure(this.currentStepResult);
            }
            if (this.engine.robot != null) {
                this.engine.robot.onFailure(this.currentStepResult);
            }
        } else {
            boolean hidden = this.reportDisabled || step.isPrefixStar() && !step.isPrint() && !this.engine.getConfig().isShowAllSteps();
            this.currentStepResult.setHidden(hidden);
        }
        this.addStepLogEmbedsAndCallResults();
        if (this.currentStepResult.isErrorIgnored()) {
            this.engine.setFailedReason(null);
        }
        if (!this.engine.isIgnoringStepErrors() && this.ignoringFailureSteps) {
            if (this.engine.getConfig().isContinueAfterContinueOnStepFailure()) {
                this.engine.setFailedReason(null);
                this.ignoringFailureSteps = false;
            } else {
                this.stopped = true;
            }
        }
        if (executed && !this.dryRun) {
            this.featureRuntime.suite.hooks.forEach(h -> h.afterStep(this.currentStepResult, this));
        }
        return this.currentStepResult;
    }

    public void afterRun() {
        try {
            this.result.setEndTime(System.currentTimeMillis());
            this.engine.logLastPerfEvent(this.result.getFailureMessageForDisplay());
            if (this.currentStepResult == null) {
                this.currentStepResult = this.result.addFakeStepResult("no steps executed", null);
            }
            if (!this.dryRun) {
                this.engine.invokeAfterHookIfConfigured(AfterHookType.AFTER_SCENARIO);
                this.featureRuntime.suite.hooks.forEach(h -> h.afterScenario(this));
                this.engine.stop(this.currentStepResult);
            }
            this.addStepLogEmbedsAndCallResults();
            if (this.tags.contains("fail")) {
                if (this.result.isFailed()) {
                    this.result.ignoreFailedStep();
                    this.result.addFakeStepResult(EXPECT_TEST_TO_FAIL_BECAUSE_OF_FAIL_TAG, null);
                } else {
                    this.result.addFakeStepResult(EXPECT_TEST_TO_FAIL_BECAUSE_OF_FAIL_TAG, new Throwable(EXPECT_TEST_TO_FAIL_BECAUSE_OF_FAIL_TAG));
                }
            }
        }
        catch (Exception e) {
            this.error = e;
            this.logError("scenario [cleanup] failed\n" + e.getMessage());
            this.currentStepResult = this.result.addFakeStepResult("scenario [cleanup] failed", e);
        }
    }

    private void addStepLogEmbedsAndCallResults() {
        boolean showLog = !this.reportDisabled && this.engine.getConfig().isShowLog();
        String stepLog = this.logAppender.collect();
        if (showLog) {
            this.currentStepResult.appendToStepLog(stepLog);
            if (this.currentStepResult.isErrorIgnored()) {
                this.currentStepResult.appendToStepLog(this.currentStepResult.getErrorMessage());
            }
        }
        if (this.callResults != null) {
            this.currentStepResult.addCallResults(this.callResults);
            this.callResults = null;
        }
        if (this.embeds != null) {
            this.currentStepResult.addEmbeds(this.embeds);
            this.embeds = null;
        }
    }

    public String toString() {
        return this.scenario.toString();
    }

    public void evaluateScenarioName() {
        String scenarioName = this.scenario.getName();
        boolean wrappedByBackTick = scenarioName != null && scenarioName.length() > 1 && '`' == scenarioName.charAt(0) && '`' == scenarioName.charAt(scenarioName.length() - 1);
        boolean hasJavascriptPlaceholder = ScenarioEngine.hasJavaScriptPlacehoder(scenarioName);
        if (wrappedByBackTick || hasJavascriptPlaceholder) {
            Object eval = scenarioName;
            if (!wrappedByBackTick) {
                eval = "`" + (String)eval + "`";
            }
            String evaluatedScenarioName = this.engine.evalJs((String)eval).getAsString();
            this.scenario.setName(evaluatedScenarioName);
        }
    }
}

