/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.KarateException;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.Table;
import com.intuit.karate.resource.MemoryResource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Step {
    private final Feature feature;
    private final Scenario scenario;
    private final int index;
    private int line;
    private int endLine;
    private List<String> comments;
    private String prefix;
    private String text;
    private String docString;
    private Table table;
    public static final List<String> PREFIXES = Arrays.asList("*", "Given", "When", "Then", "And", "But");

    public void parseAndUpdateFrom(String text) {
        MemoryResource resource;
        Feature tempFeature;
        Step tempStep;
        String stepText = ((String)text).trim();
        boolean hasPrefix = PREFIXES.stream().anyMatch(prefixValue -> stepText.startsWith((String)prefixValue));
        if (!hasPrefix) {
            text = "* " + stepText;
        }
        if ((tempStep = (tempFeature = Feature.read(resource = new MemoryResource(this.scenario.getFeature().getResource().getFile(), "Feature:\nScenario:\n" + (String)text))).getStep(0, -1, 0)) == null) {
            throw new KarateException("invalid expression: " + (String)text);
        }
        this.prefix = tempStep.prefix;
        this.text = tempStep.text;
        this.docString = tempStep.docString;
        this.table = tempStep.table;
    }

    public String getDebugInfo() {
        return String.valueOf(this.feature) + ":" + this.line;
    }

    public boolean isPrint() {
        return this.text != null && this.text.startsWith("print");
    }

    public boolean isPrefixStar() {
        return "*".equals(this.prefix);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Step(Feature feature, int index) {
        this.feature = feature;
        this.scenario = null;
        this.index = index;
    }

    public Step(Scenario scenario, int index) {
        this.scenario = scenario;
        this.feature = scenario.getFeature();
        this.index = index;
    }

    public static Step fromKarateJson(Scenario scenario, Map<String, Object> map) {
        List table;
        int index = (Integer)map.get("index");
        Boolean background = (Boolean)map.get("background");
        if (background == null) {
            background = false;
        }
        Step step = background != false ? new Step(scenario.getFeature(), index) : new Step(scenario, index);
        int line = (Integer)map.get("line");
        step.setLine(line);
        Integer endLine = (Integer)map.get("endLine");
        if (endLine == null) {
            endLine = line;
        }
        step.setEndLine(endLine);
        if (map.get("comments") instanceof List) {
            step.setComments((List)map.get("comments"));
        }
        step.setPrefix((String)map.get("prefix"));
        step.setText((String)map.get("text"));
        step.setDocString((String)map.get("docString"));
        if (map.get("table") instanceof List && (table = (List)map.get("table")) != null) {
            step.setTable(Table.fromKarateJson(table));
        }
        return step;
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.isBackground()) {
            map.put("background", true);
        }
        map.put("index", this.index);
        map.put("line", this.line);
        if (this.endLine != this.line) {
            map.put("endLine", this.endLine);
        }
        if (this.comments != null && !this.comments.isEmpty()) {
            map.put("comments", this.comments);
        }
        map.put("prefix", this.prefix);
        map.put("text", this.text);
        if (this.docString != null) {
            map.put("docString", this.docString);
        }
        if (this.table != null) {
            map.put("table", this.table.toKarateJson());
        }
        return map;
    }

    public boolean isBackground() {
        return this.scenario == null;
    }

    public boolean isOutline() {
        return this.scenario != null && this.scenario.isOutlineExample();
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLineCount() {
        return this.endLine - this.line + 1;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDocString() {
        return this.docString;
    }

    public void setDocString(String docString) {
        this.docString = docString;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void setComments(List<String> comments) {
        this.comments = comments;
    }

    public boolean isFake() {
        return this.getIndex() == -1;
    }

    public boolean isSetup() {
        return this.scenario != null && this.scenario.isSetup();
    }

    public String toString() {
        String temp = this.prefix + " " + this.text;
        if (this.docString != null) {
            temp = temp + "\n\"\"\"\n" + this.docString + "\n\"\"\"";
        }
        if (this.table != null) {
            temp = temp + " " + this.table.toString();
        }
        return temp;
    }
}

