/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.driver.Driver;
import java.util.HashMap;
import java.util.Map;

public class Keys {
    private final Driver driver;
    public static final char NULL = '\ue000';
    public static final char CANCEL = '\ue001';
    public static final char HELP = '\ue002';
    public static final char BACK_SPACE = '\ue003';
    public static final char TAB = '\ue004';
    public static final char CLEAR = '\ue005';
    public static final char RETURN = '\ue006';
    public static final char ENTER = '\ue007';
    public static final char SHIFT = '\ue008';
    public static final char CONTROL = '\ue009';
    public static final char ALT = '\ue00a';
    public static final char PAUSE = '\ue00b';
    public static final char ESCAPE = '\ue00c';
    public static final char SPACE = '\ue00d';
    public static final char PAGE_UP = '\ue00e';
    public static final char PAGE_DOWN = '\ue00f';
    public static final char END = '\ue010';
    public static final char HOME = '\ue011';
    public static final char LEFT = '\ue012';
    public static final char UP = '\ue013';
    public static final char RIGHT = '\ue014';
    public static final char DOWN = '\ue015';
    public static final char INSERT = '\ue016';
    public static final char DELETE = '\ue017';
    public static final char SEMICOLON = '\ue018';
    public static final char EQUALS = '\ue019';
    public static final char NUMPAD0 = '\ue01a';
    public static final char NUMPAD1 = '\ue01b';
    public static final char NUMPAD2 = '\ue01c';
    public static final char NUMPAD3 = '\ue01d';
    public static final char NUMPAD4 = '\ue01e';
    public static final char NUMPAD5 = '\ue01f';
    public static final char NUMPAD6 = '\ue020';
    public static final char NUMPAD7 = '\ue021';
    public static final char NUMPAD8 = '\ue022';
    public static final char NUMPAD9 = '\ue023';
    public static final char MULTIPLY = '\ue024';
    public static final char ADD = '\ue025';
    public static final char SEPARATOR = '\ue026';
    public static final char SUBTRACT = '\ue027';
    public static final char DECIMAL = '\ue028';
    public static final char DIVIDE = '\ue029';
    public static final char F1 = '\ue031';
    public static final char F2 = '\ue032';
    public static final char F3 = '\ue033';
    public static final char F4 = '\ue034';
    public static final char F5 = '\ue035';
    public static final char F6 = '\ue036';
    public static final char F7 = '\ue037';
    public static final char F8 = '\ue038';
    public static final char F9 = '\ue039';
    public static final char F10 = '\ue03a';
    public static final char F11 = '\ue03b';
    public static final char F12 = '\ue03c';
    public static final char META = '\ue03d';
    private static final Map<Character, Integer> CODES = new HashMap<Character, Integer>();
    private static final Map<Character, String> VALUES = new HashMap<Character, String>();
    public static final int CODE_SHIFT = 16;
    public static final int CODE_CONTROL = 17;
    public static final int CODE_ALT = 18;
    public static final int CODE_META = 91;

    public Keys(Driver driver) {
        this.driver = driver;
    }

    public static Integer code(char c) {
        return CODES.get(Character.valueOf(c));
    }

    public static String keyValue(char c) {
        return VALUES.get(Character.valueOf(c));
    }

    public static boolean isNormal(char c) {
        return c < '\ue000';
    }

    public static boolean isModifier(char c) {
        switch (c) {
            case '\ue008': 
            case '\ue009': 
            case '\ue00a': 
            case '\ue03d': {
                return true;
            }
        }
        return false;
    }

    public static String keyIdentifier(char c) {
        return "\\u" + Integer.toHexString(c | 0x10000).substring(1);
    }

    private static void put(char c, int code, String value) {
        CODES.put(Character.valueOf(c), code);
        VALUES.put(Character.valueOf(c), value);
    }

    static {
        Keys.put('\ue001', 3, "Cancel");
        Keys.put('\ue003', 8, "Backspace");
        Keys.put('\ue004', 9, "Tab");
        Keys.put('\ue005', 12, "Clear");
        Keys.put('\ue000', 12, "Clear");
        Keys.put('\ue006', 13, "Enter");
        Keys.put('\ue007', 13, "Enter");
        Keys.put('\ue008', 16, "Shift");
        Keys.put('\ue009', 17, "Control");
        Keys.put('\ue00a', 18, "Alt");
        Keys.put('\ue00b', 19, "Pause");
        Keys.put('\ue00c', 27, "Escape");
        Keys.put('\ue00d', 32, " ");
        Keys.put('\ue00e', 33, "PageUp");
        Keys.put('\ue00f', 34, "PageDown");
        Keys.put('\ue010', 35, "End");
        Keys.put('\ue011', 36, "Home");
        Keys.put('\ue012', 37, "ArrowLeft");
        Keys.put('\ue013', 38, "ArrowUp");
        Keys.put('\ue014', 39, "ArrowRight");
        Keys.put('\ue015', 40, "ArrowDown");
        Keys.put('\ue01a', 96, "0");
        Keys.put('\ue01b', 97, "1");
        Keys.put('\ue01c', 98, "2");
        Keys.put('\ue01d', 99, "3");
        Keys.put('\ue01e', 100, "4");
        Keys.put('\ue01f', 101, "5");
        Keys.put('\ue020', 102, "6");
        Keys.put('\ue021', 103, "7");
        Keys.put('\ue022', 104, "8");
        Keys.put('\ue023', 105, "9");
        Keys.put('\ue024', 106, "Multiply");
        Keys.put('\ue025', 107, "Add");
        Keys.put('\ue026', 108, "Separator");
        Keys.put('\ue027', 109, "Subtract");
        Keys.put('\ue028', 110, "Decimal");
        Keys.put('\ue029', 111, "Divide");
        Keys.put('\ue031', 112, "F1");
        Keys.put('\ue032', 113, "F2");
        Keys.put('\ue033', 114, "F3");
        Keys.put('\ue034', 115, "F4");
        Keys.put('\ue035', 116, "F5");
        Keys.put('\ue036', 117, "F6");
        Keys.put('\ue037', 118, "F7");
        Keys.put('\ue038', 119, "F8");
        Keys.put('\ue039', 120, "F9");
        Keys.put('\ue03a', 121, "F10");
        Keys.put('\ue03b', 122, "F11");
        Keys.put('\ue03c', 123, "F12");
        Keys.put('\ue017', 127, "Delete");
        Keys.put('\ue016', 155, "Insert");
        Keys.put('\ue002', 156, "Help");
        Keys.put('\ue03d', 91, "Meta");
        CODES.put(Character.valueOf(' '), 32);
        CODES.put(Character.valueOf(','), 44);
        CODES.put(Character.valueOf('-'), 45);
        CODES.put(Character.valueOf('.'), 46);
        CODES.put(Character.valueOf('/'), 47);
        CODES.put(Character.valueOf('0'), 48);
        CODES.put(Character.valueOf('1'), 49);
        CODES.put(Character.valueOf('2'), 50);
        CODES.put(Character.valueOf('3'), 51);
        CODES.put(Character.valueOf('4'), 52);
        CODES.put(Character.valueOf('5'), 53);
        CODES.put(Character.valueOf('6'), 54);
        CODES.put(Character.valueOf('7'), 55);
        CODES.put(Character.valueOf('8'), 56);
        CODES.put(Character.valueOf('9'), 57);
        CODES.put(Character.valueOf(';'), 59);
        CODES.put(Character.valueOf('='), 61);
        CODES.put(Character.valueOf('A'), 65);
        CODES.put(Character.valueOf('B'), 66);
        CODES.put(Character.valueOf('C'), 67);
        CODES.put(Character.valueOf('D'), 68);
        CODES.put(Character.valueOf('E'), 69);
        CODES.put(Character.valueOf('F'), 70);
        CODES.put(Character.valueOf('G'), 71);
        CODES.put(Character.valueOf('H'), 72);
        CODES.put(Character.valueOf('I'), 73);
        CODES.put(Character.valueOf('J'), 74);
        CODES.put(Character.valueOf('K'), 75);
        CODES.put(Character.valueOf('L'), 76);
        CODES.put(Character.valueOf('M'), 77);
        CODES.put(Character.valueOf('N'), 78);
        CODES.put(Character.valueOf('O'), 79);
        CODES.put(Character.valueOf('P'), 80);
        CODES.put(Character.valueOf('Q'), 81);
        CODES.put(Character.valueOf('R'), 82);
        CODES.put(Character.valueOf('S'), 83);
        CODES.put(Character.valueOf('T'), 84);
        CODES.put(Character.valueOf('U'), 85);
        CODES.put(Character.valueOf('V'), 86);
        CODES.put(Character.valueOf('W'), 87);
        CODES.put(Character.valueOf('X'), 88);
        CODES.put(Character.valueOf('Y'), 89);
        CODES.put(Character.valueOf('Z'), 90);
        CODES.put(Character.valueOf('a'), 97);
        CODES.put(Character.valueOf('b'), 98);
        CODES.put(Character.valueOf('c'), 99);
        CODES.put(Character.valueOf('d'), 100);
        CODES.put(Character.valueOf('e'), 101);
        CODES.put(Character.valueOf('f'), 102);
        CODES.put(Character.valueOf('g'), 103);
        CODES.put(Character.valueOf('h'), 104);
        CODES.put(Character.valueOf('i'), 105);
        CODES.put(Character.valueOf('j'), 106);
        CODES.put(Character.valueOf('k'), 107);
        CODES.put(Character.valueOf('l'), 108);
        CODES.put(Character.valueOf('m'), 109);
        CODES.put(Character.valueOf('n'), 110);
        CODES.put(Character.valueOf('o'), 111);
        CODES.put(Character.valueOf('p'), 112);
        CODES.put(Character.valueOf('q'), 113);
        CODES.put(Character.valueOf('r'), 114);
        CODES.put(Character.valueOf('s'), 115);
        CODES.put(Character.valueOf('t'), 116);
        CODES.put(Character.valueOf('u'), 117);
        CODES.put(Character.valueOf('v'), 118);
        CODES.put(Character.valueOf('w'), 119);
        CODES.put(Character.valueOf('x'), 120);
        CODES.put(Character.valueOf('y'), 121);
        CODES.put(Character.valueOf('z'), 122);
        CODES.put(Character.valueOf('&'), 150);
        CODES.put(Character.valueOf('*'), 151);
        CODES.put(Character.valueOf('\"'), 152);
        CODES.put(Character.valueOf('<'), 153);
        CODES.put(Character.valueOf('>'), 160);
        CODES.put(Character.valueOf('{'), 161);
        CODES.put(Character.valueOf('}'), 162);
        CODES.put(Character.valueOf('~'), 171);
        CODES.put(Character.valueOf('|'), 172);
        CODES.put(Character.valueOf('%'), 175);
        CODES.put(Character.valueOf('^'), 176);
        CODES.put(Character.valueOf('?'), 191);
        CODES.put(Character.valueOf('`'), 192);
        CODES.put(Character.valueOf('['), 219);
        CODES.put(Character.valueOf('\\'), 220);
        CODES.put(Character.valueOf(']'), 221);
        CODES.put(Character.valueOf('\''), 222);
        CODES.put(Character.valueOf('@'), 512);
        CODES.put(Character.valueOf(':'), 513);
        CODES.put(Character.valueOf('$'), 515);
        CODES.put(Character.valueOf('!'), 517);
        CODES.put(Character.valueOf('('), 519);
        CODES.put(Character.valueOf('#'), 520);
        CODES.put(Character.valueOf('+'), 521);
        CODES.put(Character.valueOf(')'), 522);
        CODES.put(Character.valueOf('_'), 523);
    }
}

