/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.safari;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import java.util.Map;

public class SafariWebDriver
extends WebDriver {
    public static final String DRIVER_TYPE = "safaridriver";

    public SafariWebDriver(DriverOptions options) {
        super(options);
    }

    public static SafariWebDriver start(Map<String, Object> map, ScenarioRuntime sr) {
        DriverOptions options = new DriverOptions(map, sr, 5555, DRIVER_TYPE);
        options.arg("--port=" + options.port);
        return new SafariWebDriver(options);
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        Integer x = (Integer)map.remove("left");
        Integer y = (Integer)map.remove("top");
        if (x != null) {
            map.put("x", x < 2 ? 2 : x);
        }
        if (y != null) {
            map.put("y", y < 2 ? 2 : y);
        }
        String json = JsonUtils.toJson(map);
        this.http.path("window", "rect").postJson(json);
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getOsType()) {
                    case MACOSX: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Safari\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }
}

