/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.graal;

import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyInstantiable;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsFunction
implements ProxyObject {
    protected static final Logger logger = LoggerFactory.getLogger(JsFunction.class);
    public static final Object LOCK = new Object();
    protected final Value value;

    protected JsFunction(Value v) {
        this.value = v;
    }

    public static ProxyExecutable wrap(Value value) {
        return new Executable(value, true);
    }

    public Value getValue() {
        return this.value;
    }

    public void putMember(String key, Value value) {
        this.value.putMember(key, new JsValue((Value)value).value);
    }

    public boolean hasMember(String key) {
        return this.value.hasMember(key);
    }

    public Object getMemberKeys() {
        return this.value.getMemberKeys().toArray(new String[0]);
    }

    public Object getMember(String key) {
        return new JsValue((Value)this.value.getMember((String)key)).value;
    }

    public boolean removeMember(String key) {
        return this.value.removeMember(key);
    }

    public static class Executable
    extends JsFunction
    implements ProxyExecutable {
        private final boolean lock;
        private final String source;

        protected Executable(Value value) {
            this(value, false);
        }

        protected Executable(Value value, boolean lock) {
            super(value);
            this.lock = lock;
            this.source = "(" + String.valueOf(value.getSourceLocation().getCharacters()) + ")";
        }

        public Object execute(JsEngine je, Object ... args) {
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = JsValue.fromJava(args[i]);
            }
            Value attached = je.evalForValue(this.source);
            return new JsValue((Value)attached.execute((Object[])newArgs)).value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(Value ... args) {
            JsEngine je;
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = JsValue.fromJava(args[i]);
            }
            if (this.lock) {
                Object i = LOCK;
                synchronized (i) {
                    return new JsValue((Value)this.value.execute((Object[])newArgs)).value;
                }
            }
            ScenarioEngine se = ScenarioEngine.get();
            JsEngine jsEngine = je = se == null ? null : se.getJsEngine();
            if (je == null || je.context.equals((Object)this.value.getContext())) {
                return new JsValue((Value)this.value.execute((Object[])newArgs)).value;
            }
            Value attached = je.evalForValue(this.source);
            return new JsValue((Value)attached.execute((Object[])newArgs)).value;
        }
    }

    protected static class Instantiable
    extends Executable
    implements ProxyInstantiable {
        protected Instantiable(Value value) {
            super(value);
        }

        public Object newInstance(Value ... args) {
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = JsValue.fromJava(args[i]);
            }
            JsEngine je = ScenarioEngine.get().getJsEngine();
            Value wrappedWithParentheses = je.evalForValue("(" + String.valueOf(this.value.getSourceLocation().getCharacters()) + ")");
            return new JsValue((Value)wrappedWithParentheses.execute((Object[])newArgs)).value;
        }
    }
}

