/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.graal;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.graal.JsFunction;
import com.intuit.karate.graal.JsList;
import com.intuit.karate.graal.JsMap;
import com.intuit.karate.graal.JsXml;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class JsValue {
    private static final Logger logger = LoggerFactory.getLogger(JsValue.class);
    public static final JsValue NULL = new JsValue(Value.asValue(null));
    private final Value original;
    protected final Object value;
    public final Type type;

    public JsValue(Value v) {
        if (v == null) {
            throw new RuntimeException("JsValue() constructor argument has to be not-null");
        }
        this.original = v;
        try {
            if (v.isNull()) {
                this.value = null;
                this.type = Type.NULL;
            } else if (v.isHostObject()) {
                this.value = v.isMetaObject() ? v : v.asHostObject();
                this.type = Type.OTHER;
            } else if (v.isProxyObject()) {
                Proxy o = v.asProxyObject();
                if (o instanceof JsXml) {
                    this.value = ((JsXml)o).getNode();
                    this.type = Type.XML;
                } else if (o instanceof JsMap) {
                    this.value = ((JsMap)o).getMap();
                    this.type = Type.OBJECT;
                } else if (o instanceof JsList) {
                    this.value = ((JsList)o).getList();
                    this.type = Type.ARRAY;
                } else if (o instanceof ProxyExecutable) {
                    this.value = o;
                    this.type = Type.FUNCTION;
                } else {
                    this.value = v.as(Object.class);
                    this.type = Type.OTHER;
                }
            } else if (v.hasArrayElements()) {
                int size = (int)v.getArraySize();
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    Value child = v.getArrayElement((long)i);
                    list.add(new JsValue((Value)child).value);
                }
                this.value = list;
                this.type = Type.ARRAY;
            } else if (v.hasMembers()) {
                if (v.canExecute()) {
                    this.value = v.canInstantiate() ? new JsFunction.Instantiable(v) : new JsFunction.Executable(v);
                    this.type = Type.FUNCTION;
                } else {
                    Set keys = v.getMemberKeys();
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(keys.size());
                    for (String key : keys) {
                        Value child = v.getMember(key);
                        map.put(key, new JsValue((Value)child).value);
                    }
                    this.value = map;
                    this.type = Type.OBJECT;
                }
            } else if (v.isNumber()) {
                this.value = v.as(Number.class);
                this.type = Type.OTHER;
            } else if (v.isBoolean()) {
                this.value = v.asBoolean();
                this.type = Type.OTHER;
            } else if (v.isString()) {
                this.value = v.asString();
                this.type = Type.OTHER;
            } else {
                this.value = v.as(Object.class);
                this.type = this.value instanceof Function ? Type.FUNCTION : Type.OTHER;
            }
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("js conversion failed", (Throwable)e);
            }
            throw e;
        }
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public Map<String, Object> getAsMap() {
        return (Map)this.value;
    }

    public List getAsList() {
        return (List)this.value;
    }

    public Value getOriginal() {
        return this.original;
    }

    public boolean isXml() {
        return this.type == Type.XML;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isObject() {
        return this.type == Type.OBJECT;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY;
    }

    public boolean isTrue() {
        if (this.type != Type.OTHER || !Boolean.class.equals(this.value.getClass())) {
            return false;
        }
        return (Boolean)this.value;
    }

    public boolean isFunction() {
        return this.type == Type.FUNCTION;
    }

    public boolean isOther() {
        return this.type == Type.OTHER;
    }

    public String toString() {
        return this.original.toString();
    }

    public String toJsonOrXmlString(boolean pretty) {
        return JsonUtils.toString(this.value, pretty);
    }

    public String getAsString() {
        return JsonUtils.toString(this.value);
    }

    public static Object fromJava(Object o) {
        if (o instanceof Function || o instanceof Proxy) {
            return o;
        }
        if (o instanceof List) {
            return new JsList((List)o);
        }
        if (o instanceof Map) {
            return new JsMap((Map)o);
        }
        if (o instanceof Node) {
            return new JsXml((Node)o);
        }
        return o;
    }

    public static Object toJava(Value v) {
        return new JsValue(v).getValue();
    }

    public static Object unWrap(Object o) {
        if (o instanceof JsXml) {
            return ((JsXml)o).getNode();
        }
        if (o instanceof JsMap) {
            return ((JsMap)o).getMap();
        }
        if (o instanceof JsList) {
            return ((JsList)o).getList();
        }
        return o;
    }

    public static byte[] toBytes(Value v) {
        return JsonUtils.toBytes(JsValue.toJava(v));
    }

    public static boolean isTruthy(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        return true;
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        FUNCTION,
        XML,
        NULL,
        OTHER;

    }
}

