/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsLambdaHandler {
    protected static final Logger logger = LoggerFactory.getLogger(AwsLambdaHandler.class);
    private static final String REQUEST_CONTEXT = "requestContext";
    private static final String DOMAIN_NAME = "domainName";
    private static final String HTTP = "http";
    private static final String HTTPS_PREFIX = "https://";
    private static final String METHOD = "method";
    private static final String RAW_PATH = "rawPath";
    private static final String QUERY_STRING_PARAMETERS = "queryStringParameters";
    private static final String HEADERS = "headers";
    private static final String COOKIES = "cookies";
    private static final String BODY = "body";
    private static final String IS_BASE64_ENCODED = "isBase64Encoded";
    private static final String STATUS_CODE = "statusCode";
    private final ServerHandler handler;

    public AwsLambdaHandler(ServerHandler handler) {
        this.handler = handler;
    }

    public void handle(InputStream in, OutputStream out) throws IOException {
        Map req = (Map)JSONValue.parse((InputStream)in);
        if (logger.isTraceEnabled()) {
            logger.trace("request: {}", (Object)req);
        }
        Map ctx = (Map)req.get(REQUEST_CONTEXT);
        String domainName = (String)ctx.get(DOMAIN_NAME);
        Map http = (Map)ctx.get(HTTP);
        String method = (String)http.get(METHOD);
        String path = (String)req.get(RAW_PATH);
        Map rawParams = (Map)req.get(QUERY_STRING_PARAMETERS);
        Map rawHeaders = (Map)req.get(HEADERS);
        List rawCookies = (List)req.get(COOKIES);
        String body = (String)req.get(BODY);
        Boolean isBase64Encoded = (Boolean)req.get(IS_BASE64_ENCODED);
        Request request = new Request();
        request.setUrlBase(HTTPS_PREFIX + domainName);
        request.setMethod(method);
        request.setPath(path);
        if (rawParams != null) {
            rawParams.forEach((k, v) -> request.setParamCommaDelimited((String)k, (String)v));
        }
        if (rawHeaders != null) {
            rawHeaders.forEach((k, v) -> request.setHeaderCommaDelimited((String)k, (String)v));
        }
        if (rawCookies != null) {
            request.setCookiesRaw(rawCookies);
        }
        if (body != null) {
            if (isBase64Encoded.booleanValue()) {
                request.setBody(Base64.getDecoder().decode(body));
            } else {
                request.setBody(FileUtils.toBytes(body));
            }
        }
        Response response = this.handler.handle(request);
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        res.put(STATUS_CODE, response.getStatus());
        Map<String, List<String>> responseHeaders = response.getHeaders();
        if (responseHeaders != null) {
            HashMap temp = new HashMap(responseHeaders.size());
            responseHeaders.forEach((k, v) -> temp.put(k, StringUtils.join(v, ",")));
            res.put(HEADERS, temp);
        }
        boolean isBinary = response.isBinary();
        res.put(IS_BASE64_ENCODED, isBinary);
        byte[] responseBody = response.getBody();
        body = responseBody == null ? null : (isBinary ? Base64.getEncoder().encodeToString(responseBody) : FileUtils.toString(responseBody));
        res.put(BODY, body);
        if (logger.isTraceEnabled()) {
            logger.trace("response: {}", res);
        }
        out.write(JsonUtils.toJsonBytes(res));
    }
}

