/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.GenericHttpHeaderTracking;
import com.intuit.karate.http.HttpServerHandler;
import com.intuit.karate.http.RequestHandler;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.ServerHandler;
import com.intuit.karate.http.SslContextFactory;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.cors.CorsService;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    protected static final Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private final Server server;
    private final CompletableFuture<Void> future;
    private final int port;

    public void waitSync() {
        try {
            Thread.currentThread().join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public CompletableFuture stop() {
        return this.server.stop();
    }

    public static Builder handler(ServerHandler handler) {
        return new Builder().handler(handler);
    }

    public static Builder root(String root) {
        return HttpServer.config(new ServerConfig(root));
    }

    public static Builder config(ServerConfig config) {
        return HttpServer.handler(new RequestHandler(config));
    }

    public HttpServer(ServerBuilder sb) {
        HttpService httpStopService = (ctx, req) -> {
            logger.debug("received command to stop server: {}", (Object)req.path());
            this.stop();
            return HttpResponse.of((HttpStatus)HttpStatus.ACCEPTED);
        };
        sb.service("/__admin/stop", httpStopService);
        this.server = sb.build();
        this.future = this.server.start();
        this.future.join();
        this.port = this.server.activePort().localAddress().getPort();
        logger.debug("server started: {}:{}", (Object)this.server.defaultHostname(), (Object)this.port);
    }

    public static class Builder {
        int port;
        boolean ssl;
        boolean local = true;
        File certFile;
        File keyFile;
        boolean corsEnabled;
        ServerHandler handler;
        boolean keepOriginalHeaders;

        public Builder local(boolean value) {
            this.local = value;
            return this;
        }

        public Builder http(int value) {
            this.port = value;
            return this;
        }

        public Builder https(int value) {
            this.ssl = true;
            this.port = value;
            return this;
        }

        public Builder certFile(File value) {
            this.certFile = value;
            return this;
        }

        public Builder keyFile(File value) {
            this.keyFile = value;
            return this;
        }

        public Builder corsEnabled(boolean value) {
            this.corsEnabled = value;
            return this;
        }

        public Builder handler(ServerHandler value) {
            this.handler = value;
            return this;
        }

        public Builder keepOriginalHeaders(boolean value) {
            this.keepOriginalHeaders = value;
            return this;
        }

        public HttpServer build() {
            ServerBuilder sb = Server.builder();
            sb.requestTimeoutMillis(0L);
            sb.maxRequestLength(0L);
            if (this.ssl) {
                if (this.local) {
                    sb.localPort(this.port, new SessionProtocol[]{SessionProtocol.HTTPS});
                } else {
                    sb.https(this.port);
                }
                SslContextFactory factory = new SslContextFactory();
                factory.setCertFile(this.certFile);
                factory.setKeyFile(this.keyFile);
                factory.build();
                sb.tls(factory.getCertFile(), factory.getKeyFile());
            } else if (this.local) {
                sb.localPort(this.port, new SessionProtocol[]{SessionProtocol.HTTP});
            } else {
                sb.http(this.port);
            }
            HttpServerHandler.Builder serverHandlerBuilder = HttpServerHandler.Builder.builder();
            serverHandlerBuilder.handler(this.handler);
            if (this.keepOriginalHeaders) {
                GenericHttpHeaderTracking headerTracking = new GenericHttpHeaderTracking();
                sb.http1HeaderNaming(http2HeaderName -> headerTracking.getOriginalHeader(String.valueOf(http2HeaderName)));
                serverHandlerBuilder.httpHeaderTracking(headerTracking);
            }
            HttpServerHandler service = serverHandlerBuilder.build();
            if (this.corsEnabled) {
                service = (HttpService)service.decorate(CorsService.builderForAnyOrigin().allowAllRequestHeaders(true).newDecorator());
            }
            sb.service("prefix:/", (HttpService)service);
            return new HttpServer(sb);
        }
    }
}

