/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Logger;
import com.intuit.karate.core.Config;
import com.intuit.karate.http.ArmeriaHttpClient;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.JvmSessionStore;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.ServerContext;
import com.intuit.karate.http.Session;
import com.intuit.karate.http.SessionStore;
import com.intuit.karate.resource.ResourceResolver;
import com.linecorp.armeria.common.RequestContext;
import java.util.HashMap;
import java.util.function.Function;

public class ServerConfig {
    private final ResourceResolver resourceResolver;
    private String hostContextPath = null;
    private String homePagePath = "/index";
    private String signinPagePath = "/signin";
    private String signoutPagePath = "/signout";
    private String sessionCookieName = "karate.sid";
    private boolean stripContextPathFromRequest;
    private boolean useGlobalSession;
    private boolean autoCreateSession;
    private boolean noCache;
    private boolean devMode;
    private SessionStore sessionStore = JvmSessionStore.INSTANCE;
    private int sessionExpirySeconds = 600;
    public static final Session GLOBAL_SESSION = new Session("-1", new HashMap<String, Object>(), -1L, -1L, -1L);
    private Function<Request, ServerContext> contextFactory = request -> {
        ServerContext context = new ServerContext(this, (Request)request);
        if (context.setApiIfPathStartsWith("/api/")) {
            context.setLockNeeded(true);
        } else {
            context.setHttpGetAllowed(true);
        }
        return context;
    };
    private Config httpClientConfig = new Config();
    private Logger logger = new Logger();
    private Function<Request, HttpClient> httpClientFactory = request -> {
        RequestContext context = request == null ? null : request.getRequestContext();
        ArmeriaHttpClient client = new ArmeriaHttpClient(this.httpClientConfig, this.logger);
        client.setRequestContext(context);
        return client;
    };

    public ServerConfig(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public ServerConfig(String root) {
        this(new ResourceResolver(root));
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getHostContextPath() {
        return this.hostContextPath;
    }

    public String getHomePagePath() {
        return this.homePagePath;
    }

    public String getSigninPagePath() {
        return this.signinPagePath;
    }

    public String getSignoutPagePath() {
        return this.signoutPagePath;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public boolean isStripContextPathFromRequest() {
        return this.stripContextPathFromRequest;
    }

    public boolean isUseGlobalSession() {
        return this.useGlobalSession;
    }

    public boolean isAutoCreateSession() {
        return this.autoCreateSession;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public int getSessionExpirySeconds() {
        return this.sessionExpirySeconds;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public Function<Request, ServerContext> getContextFactory() {
        return this.contextFactory;
    }

    public Function<Request, HttpClient> getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public ServerConfig hostContextPath(String value) {
        if (((String)value).charAt(0) != '/') {
            value = "/" + (String)value;
        }
        if (!((String)value).endsWith("/")) {
            value = (String)value + "/";
        }
        this.hostContextPath = value;
        return this;
    }

    public ServerConfig homePagePath(String value) {
        this.homePagePath = value;
        return this;
    }

    public ServerConfig signinPagePath(String value) {
        this.signinPagePath = value;
        return this;
    }

    public ServerConfig signoutPagePath(String value) {
        this.signoutPagePath = value;
        return this;
    }

    public ServerConfig sessionCookieName(String value) {
        this.sessionCookieName = value;
        return this;
    }

    public ServerConfig stripContextPathFromRequest(boolean value) {
        this.stripContextPathFromRequest = value;
        return this;
    }

    public ServerConfig useGlobalSession(boolean value) {
        this.useGlobalSession = value;
        return this;
    }

    public ServerConfig autoCreateSession(boolean value) {
        this.autoCreateSession = value;
        return this;
    }

    public ServerConfig noCache(boolean value) {
        this.noCache = value;
        return this;
    }

    public ServerConfig devMode(boolean value) {
        this.devMode = value;
        return this;
    }

    public ServerConfig sessionStore(SessionStore value) {
        this.sessionStore = value;
        return this;
    }

    public ServerConfig sessionExpirySeconds(int value) {
        this.sessionExpirySeconds = value;
        return this;
    }

    public ServerConfig contextFactory(Function<Request, ServerContext> value) {
        this.contextFactory = value;
        return this;
    }

    public ServerConfig httpClientFactory(Function<Request, HttpClient> value) {
        this.httpClientFactory = value;
        return this;
    }
}

