/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class WebSocketOptions {
    private final URI uri;
    private String subProtocol;
    private final int port;
    private final boolean ssl;
    private Function<String, Boolean> textHandler;
    private Function<byte[], Boolean> binaryHandler;
    private Map<String, Object> headers;
    private int maxPayloadSize = 0x400000;
    private boolean useFrameAggregation = false;

    public WebSocketOptions(String url) {
        this(url, null);
    }

    public WebSocketOptions(String url, Map<String, Object> options) {
        this.uri = URI.create(url);
        this.ssl = "wss".equalsIgnoreCase(this.uri.getScheme());
        int n = this.uri.getPort() == -1 ? (this.ssl ? 443 : 80) : (this.port = this.uri.getPort());
        if (options != null) {
            Boolean tempUseFrameAggregation;
            this.subProtocol = (String)options.get("subProtocol");
            Integer temp = (Integer)options.get("maxPayloadSize");
            if (temp != null) {
                this.maxPayloadSize = temp;
            }
            if ((tempUseFrameAggregation = (Boolean)options.get("useFrameAggregation")) != null) {
                this.useFrameAggregation = tempUseFrameAggregation;
            }
            this.headers = (Map)options.get("headers");
        }
    }

    public void setTextConsumer(Consumer<String> consumer) {
        this.textHandler = t -> {
            consumer.accept((String)t);
            return false;
        };
    }

    public URI getUri() {
        return this.uri;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    public void setSubProtocol(String subProtocol) {
        this.subProtocol = subProtocol;
    }

    public Function<String, Boolean> getTextHandler() {
        return this.textHandler;
    }

    public void setTextHandler(Function<String, Boolean> textHandler) {
        this.textHandler = textHandler;
    }

    public Function<byte[], Boolean> getBinaryHandler() {
        return this.binaryHandler;
    }

    public void setBinaryHandler(Function<byte[], Boolean> binaryHandler) {
        this.binaryHandler = binaryHandler;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    public boolean getUseFrameAggregation() {
        return this.useFrameAggregation;
    }

    public void setUseFrameAggregation(boolean useFrameAggregation) {
        this.useFrameAggregation = useFrameAggregation;
    }
}

