/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.resource;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.resource.FileResource;
import com.intuit.karate.resource.JarResource;
import com.intuit.karate.resource.Resource;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);
    private static final ScanResult SCAN_RESULT = new ClassGraph().acceptPaths(new String[]{"/"}).scan(1);
    private static final ClassLoader CLASS_LOADER = ResourceUtils.class.getClassLoader();

    private ResourceUtils() {
    }

    public static List<FeatureCall> findFeatureFiles(File workingDir, List<String> paths, String scenarioName) {
        ArrayList<FeatureCall> features = new ArrayList<FeatureCall>();
        if (paths == null || paths.isEmpty()) {
            return features;
        }
        if (paths.size() == 1) {
            String callTag;
            int line;
            String path = paths.get(0);
            int pos = path.indexOf(".feature:");
            if (pos != -1) {
                line = Integer.valueOf(path.substring(pos + 9));
                path = path.substring(0, pos + 8);
            } else {
                line = -1;
            }
            pos = path.indexOf(64);
            if (pos != -1) {
                callTag = path.substring(pos);
                path = path.substring(0, pos);
            } else {
                callTag = null;
            }
            if (path.endsWith(".feature")) {
                Resource resource = ResourceUtils.getResource(workingDir, path);
                Feature feature = Feature.read(resource);
                features.add(new FeatureCall(feature, callTag, line, scenarioName));
                return features;
            }
        }
        List<Resource> resources = ResourceUtils.findResourcesByExtension(workingDir, "feature", paths);
        for (Resource resource : resources) {
            features.add(new FeatureCall(Feature.read(resource), null, -1, scenarioName));
        }
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResource(File workingDir, String path) {
        if (path.startsWith("classpath:")) {
            File file = ResourceUtils.classPathToFile(path = ResourceUtils.removePrefix(path));
            if (file != null) {
                return new FileResource(file, true, path);
            }
            ArrayList resources = new ArrayList();
            ScanResult scanResult = SCAN_RESULT;
            synchronized (scanResult) {
                ResourceList rl = SCAN_RESULT.getResourcesWithPath(path);
                if (rl == null) {
                    rl = ResourceList.emptyList();
                }
                rl.forEachByteArrayIgnoringIOException((res, bytes) -> {
                    URI uri = res.getURI();
                    if ("file".equals(uri.getScheme())) {
                        File found = Paths.get(uri).toFile();
                        resources.add(new FileResource(found, true, res.getPath()));
                    } else {
                        resources.add(new JarResource(bytes, res.getPath(), uri));
                    }
                });
            }
            if (resources.isEmpty()) {
                throw new RuntimeException("not found: " + path);
            }
            return (Resource)resources.get(0);
        }
        File file = new File(ResourceUtils.removePrefix(path = path.replace('\\', '/')));
        if (!file.exists()) {
            throw new RuntimeException("not found: " + path);
        }
        Path relativePath = workingDir.toPath().relativize(file.getAbsoluteFile().toPath());
        return new FileResource(file, false, relativePath.toString());
    }

    public static Collection<Resource> findResourcesByExtension(File workingDir, String extension, String path) {
        return ResourceUtils.findResourcesByExtension(workingDir, extension, Collections.singletonList(path));
    }

    public static List<Resource> findResourcesByExtension(File workingDir, String extension, List<String> paths) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        ArrayList<File> fileRoots = new ArrayList<File>();
        ArrayList<String> pathRoots = new ArrayList<String>();
        for (String path : paths) {
            if (path.endsWith("." + extension)) {
                results.add(ResourceUtils.getResource(workingDir, path));
                continue;
            }
            if (path.startsWith("classpath:")) {
                pathRoots.add(ResourceUtils.removePrefix(path));
                continue;
            }
            fileRoots.add(new File(ResourceUtils.removePrefix(path)));
        }
        if (!fileRoots.isEmpty()) {
            results.addAll(ResourceUtils.findFilesByExtension(workingDir, extension, fileRoots));
        } else if (results.isEmpty() && !pathRoots.isEmpty()) {
            String[] searchPaths = pathRoots.toArray(new String[pathRoots.size()]);
            try (ScanResult scanResult = new ClassGraph().acceptPaths(searchPaths).scan(1);){
                ResourceList rl = scanResult.getResourcesWithExtension(extension);
                rl.forEachByteArrayIgnoringIOException((res, bytes) -> {
                    URI uri = res.getURI();
                    if ("file".equals(uri.getScheme())) {
                        File file = Paths.get(uri).toFile();
                        results.add(new FileResource(file, true, res.getPath()));
                    } else {
                        results.add(new JarResource(bytes, res.getPath(), uri));
                    }
                });
            }
        }
        return results;
    }

    private static List<Resource> findFilesByExtension(File workingDir, String extension, List<File> files) {
        ArrayList<File> results = new ArrayList<File>();
        for (File base : files) {
            Path searchPath = base.toPath();
            try {
                Stream<Path> stream = Files.walk(searchPath, new FileVisitOption[0]);
                Iterator paths = stream.iterator();
                while (paths.hasNext()) {
                    Path path = (Path)paths.next();
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith("." + extension)) continue;
                    results.add(path.toFile());
                }
            }
            catch (IOException e) {
                logger.trace("unable to walk path: {} - {}", (Object)searchPath, (Object)e.getMessage());
            }
        }
        return results.stream().map(f -> {
            Path relativePath = workingDir.toPath().relativize(f.getAbsoluteFile().toPath());
            return new FileResource((File)f, false, relativePath.toString());
        }).collect(Collectors.toList());
    }

    public static File getFileRelativeTo(Class clazz, String path) {
        Path dirPath = ResourceUtils.getPathContaining(clazz);
        File file = new File(String.valueOf(dirPath) + File.separator + path);
        if (file.exists()) {
            return file;
        }
        try {
            URL relativePath = clazz.getClassLoader().getResource(ResourceUtils.toPathFromClassPathRoot(clazz) + File.separator + path);
            return Paths.get(relativePath.toURI()).toFile();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot find " + path + " relative to " + String.valueOf(clazz) + ", " + e.getMessage());
        }
    }

    public static Path getPathContaining(Class clazz) {
        String relative = ResourceUtils.toPathFromClassPathRoot(clazz);
        URL url = clazz.getClassLoader().getResource(relative);
        try {
            return Paths.get(url.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getDirContaining(Class clazz) {
        Path path = ResourceUtils.getPathContaining(clazz);
        return path.toFile();
    }

    public static String toPathFromClassPathRoot(Class clazz) {
        Package p = clazz.getPackage();
        String relative = "";
        if (p != null) {
            relative = p.getName().replace('.', '/');
        }
        return relative;
    }

    protected static String removePrefix(String text) {
        if (text.startsWith("classpath:") || text.startsWith("file:")) {
            return text.substring(text.indexOf(58) + 1);
        }
        return text;
    }

    public static String getParentPath(String relativePath) {
        int pos = relativePath.lastIndexOf(47);
        return pos == -1 ? "" : relativePath.substring(0, pos + 1);
    }

    public static InputStream classPathResourceToStream(String path) {
        return CLASS_LOADER.getResourceAsStream(path);
    }

    public static String classPathResourceToString(String path) {
        return FileUtils.toString(ResourceUtils.classPathResourceToStream(path));
    }

    public static File classPathToFile(String path) {
        URL url = CLASS_LOADER.getResource(path);
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        try {
            return Paths.get(url.toURI()).toFile();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static File classPathOrFile(String path) {
        File temp = ResourceUtils.classPathToFile(path);
        if (temp != null) {
            return temp;
        }
        temp = new File(path);
        return temp.exists() ? temp : null;
    }
}

