/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.template.KarateEngineContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;
import org.thymeleaf.processor.element.AbstractElementModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class KaSetElemProcessor
extends AbstractElementModelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KaSetElemProcessor.class);
    protected static final String SET = "set";

    public KaSetElemProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, SET, true, 1000);
    }

    protected void doProcess(ITemplateContext ctx, IModel model, IElementModelStructureHandler sh) {
        int depth = ctx.getElementStack().size();
        IProcessableElementTag tag = (IProcessableElementTag)ctx.getElementStack().get(depth - 1);
        String name = tag.getAttributeValue(this.getDialectPrefix(), SET);
        int n = model.size();
        StringBuilder sb = new StringBuilder();
        while (n-- != 0) {
            ITemplateEvent event = model.get(n);
            if (!(event instanceof IText)) continue;
            sb.append(((IText)event).getText());
        }
        KarateEngineContext.get().setLocal(name, sb.toString().trim());
        model.reset();
    }
}

