/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.http.RequestCycle;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.ServerContext;
import com.intuit.karate.resource.ResourceResolver;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.KarateScriptDialect;
import com.intuit.karate.template.KarateServerDialect;
import com.intuit.karate.template.KarateTemplateEngine;
import com.intuit.karate.template.ResourceHtmlTemplateResolver;
import com.intuit.karate.template.ServerHtmlTemplateResolver;
import com.intuit.karate.template.StringHtmlTemplateResolver;
import org.thymeleaf.dialect.IDialect;

public class TemplateUtils {
    private TemplateUtils() {
    }

    private static KarateTemplateEngine initEngine(JsEngine je, ResourceResolver resolver, boolean server) {
        ServerConfig config = new ServerConfig(resolver);
        ServerContext sc = new ServerContext(config, null);
        je.put("context", sc);
        return new KarateTemplateEngine(() -> je, new IDialect[]{server ? new KarateServerDialect(config) : new KarateScriptDialect(config)});
    }

    public static KarateTemplateEngine forServer(ServerConfig config) {
        KarateTemplateEngine engine = new KarateTemplateEngine(() -> RequestCycle.get().getEngine(), new IDialect[]{new KarateServerDialect(config)});
        engine.setTemplateResolver(new ServerHtmlTemplateResolver(config.getResourceResolver(), config.isDevMode()));
        return engine;
    }

    public static KarateTemplateEngine forStrings(JsEngine je, ResourceResolver resourceResolver) {
        KarateTemplateEngine engine = TemplateUtils.initEngine(je, resourceResolver, false);
        engine.setTemplateResolver(StringHtmlTemplateResolver.INSTANCE);
        engine.addTemplateResolver(new ResourceHtmlTemplateResolver(resourceResolver));
        return engine;
    }

    public static KarateTemplateEngine forResourceResolver(JsEngine je, ResourceResolver resourceResolver) {
        KarateTemplateEngine engine = TemplateUtils.initEngine(je, resourceResolver, false);
        engine.setTemplateResolver(new ResourceHtmlTemplateResolver(resourceResolver));
        return engine;
    }

    public static KarateTemplateEngine forServerResolver(JsEngine je, ResourceResolver resourceResolver, boolean devMode) {
        KarateTemplateEngine engine = TemplateUtils.initEngine(je, resourceResolver, true);
        engine.setTemplateResolver(new ServerHtmlTemplateResolver(resourceResolver, devMode));
        return engine;
    }

    public static KarateTemplateEngine forResourceRoot(JsEngine je, String root) {
        return TemplateUtils.forResourceResolver(je, new ResourceResolver(root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderHtmlResource(String path, JsEngine je, ResourceResolver resourceResolver, boolean devMode) {
        KarateEngineContext old = KarateEngineContext.get();
        try {
            KarateTemplateEngine kte = TemplateUtils.forServerResolver(je, resourceResolver, devMode);
            String string = kte.process(path);
            return string;
        }
        finally {
            KarateEngineContext.set(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderHtmlString(String html, JsEngine je, ResourceResolver resourceResolver) {
        KarateEngineContext old = KarateEngineContext.get();
        try {
            KarateTemplateEngine kte = TemplateUtils.forStrings(je, resourceResolver);
            String string = kte.process(html);
            return string;
        }
        finally {
            KarateEngineContext.set(old);
        }
    }
}

