/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import com.intuit.karate.Json;
import io.karatelabs.debug.DapMessage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.handler.codec.ByteToMessageDecoder;
import karate.io.netty.util.ByteProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(DapDecoder.class);
    private int remaining;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int pos;
        if (this.remaining > 0 && in.readableBytes() >= this.remaining) {
            out.add(DapDecoder.encode(in, this.remaining));
            this.remaining = 0;
        }
        while ((pos = DapDecoder.findCrLfCrLf(in)) != -1) {
            int delimiterPos = pos;
            while (in.getByte(--pos) != 58) {
            }
            in.readerIndex(++pos);
            CharSequence lengthString = in.readCharSequence(delimiterPos - pos, StandardCharsets.UTF_8);
            int length = Integer.valueOf(lengthString.toString().trim());
            in.readerIndex(delimiterPos + 4);
            if (in.readableBytes() >= length) {
                out.add(DapDecoder.encode(in, length));
                this.remaining = 0;
                continue;
            }
            this.remaining = length;
        }
    }

    private static int findCrLfCrLf(ByteBuf buffer) {
        int more;
        int totalLength = buffer.readableBytes();
        int readerIndex = buffer.readerIndex();
        int i = buffer.forEachByte(readerIndex, totalLength, ByteProcessor.FIND_LF);
        if (i > 0 && buffer.getByte(i - 1) == 13 && (more = readerIndex + totalLength - i) > 1 && buffer.getByte(i + 1) == 13 && buffer.getByte(i + 2) == 10) {
            return i - 1;
        }
        return -1;
    }

    private static DapMessage encode(ByteBuf in, int length) {
        String msg = in.readCharSequence(length, StandardCharsets.UTF_8).toString();
        if (logger.isTraceEnabled()) {
            logger.trace(">> {}", (Object)msg);
        }
        Map map = (Map)Json.of((Object)msg).value();
        return new DapMessage(map);
    }
}

