/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Main;
import com.intuit.karate.Runner;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.StringUtils;
import com.intuit.karate.cli.IdeMain;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.RuntimeHookFactory;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Variable;
import io.karatelabs.debug.Breakpoint;
import io.karatelabs.debug.DapMessage;
import io.karatelabs.debug.DapServer;
import io.karatelabs.debug.DebugThread;
import io.karatelabs.debug.SourceBreakpoints;
import io.karatelabs.debug.StackFrame;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapServerHandler
extends SimpleChannelInboundHandler<DapMessage>
implements RuntimeHookFactory {
    private static final Logger logger = LoggerFactory.getLogger(DapServerHandler.class);
    private final DapServer server;
    private Channel channel;
    private int nextSeq;
    private long nextFrameId;
    private long nextVariablesReference = 1000L;
    private long focusedFrameId;
    private Thread runnerThread;
    private final Map<String, SourceBreakpoints> BREAKPOINTS = new ConcurrentHashMap<String, SourceBreakpoints>();
    protected final Map<Long, DebugThread> THREADS = new ConcurrentHashMap<Long, DebugThread>();
    protected final Map<Long, ScenarioRuntime> FRAMES = new ConcurrentHashMap<Long, ScenarioRuntime>();
    protected final Map<Long, Stack<Map<String, Variable>>> FRAME_VARS = new ConcurrentHashMap<Long, Stack<Map<String, Variable>>>();
    protected final Map<Long, Map.Entry<String, Variable>> VARIABLES = new ConcurrentHashMap<Long, Map.Entry<String, Variable>>();
    private List<String> launchArgs;
    private String launchCommand;
    private String preStep;
    private static final String TEST_CLASSES = "/test-classes/";
    private static final String CLASSES_TEST = "/classes/java/test/";

    public DapServerHandler(DapServer server) {
        this.server = server;
    }

    private static int findPos(String path) {
        int pos = path.indexOf(TEST_CLASSES);
        if (pos != -1) {
            return pos + TEST_CLASSES.length();
        }
        pos = path.indexOf(CLASSES_TEST);
        if (pos != -1) {
            return pos + CLASSES_TEST.length();
        }
        return -1;
    }

    private SourceBreakpoints lookup(String pathEnd) {
        for (Map.Entry<String, SourceBreakpoints> entry : this.BREAKPOINTS.entrySet()) {
            if (!entry.getKey().endsWith(pathEnd)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected Breakpoint resolveBreakpoint(Step step, int line, ScenarioRuntime context) {
        Feature feature = step.getFeature();
        File file = feature.getResource().getFile();
        if (file == null) {
            return null;
        }
        String path = this.normalizePath(file.getPath());
        int pos = DapServerHandler.findPos(path);
        SourceBreakpoints sb = pos != -1 ? this.lookup(path.substring(pos)) : this.BREAKPOINTS.get(path);
        if (sb == null) {
            return null;
        }
        return sb.resolveBreakpoint(line, context);
    }

    protected String normalizePath(String path) {
        Object normalizedPath = Paths.get(path, new String[0]).normalize().toString();
        if (FileUtils.isOsWindows() && path.matches("^[a-zA-Z]:\\\\.*")) {
            normalizedPath = ((String)normalizedPath).substring(0, 1).toUpperCase() + ((String)normalizedPath).substring(1);
        }
        return normalizedPath;
    }

    private DebugThread thread(DapMessage dm) {
        Number threadId = dm.getThreadId();
        if (threadId == null) {
            return null;
        }
        return this.THREADS.get(threadId.longValue());
    }

    private List<Map<String, Object>> frames(Number threadId) {
        if (threadId == null) {
            return Collections.EMPTY_LIST;
        }
        DebugThread thread = this.THREADS.get(threadId.longValue());
        if (thread == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> frameIds = new ArrayList<Long>(thread.stack);
        Collections.reverse(frameIds);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(frameIds.size());
        for (Long frameId : frameIds) {
            ScenarioRuntime context = this.FRAMES.get(frameId);
            list.add(new StackFrame(frameId, context).toMap());
        }
        return list;
    }

    private List<Map<String, Object>> variables(Long frameId) {
        if (frameId == null) {
            return Collections.EMPTY_LIST;
        }
        String parentExpression = "";
        Map<Object, Object> vars = null;
        if (this.FRAME_VARS.containsKey(frameId)) {
            this.focusedFrameId = frameId;
            Stack<Map<String, Variable>> varsStack = this.FRAME_VARS.get(frameId);
            if (varsStack.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            vars = varsStack.peek();
        } else if (this.VARIABLES.containsKey(frameId)) {
            vars = new HashMap();
            Map.Entry<String, Variable> varEntry = this.VARIABLES.get(frameId);
            parentExpression = varEntry.getKey();
            Variable var = varEntry.getValue();
            if (var.type == Variable.Type.LIST) {
                List list = (List)var.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    vars.put(String.format("[%s]", i), new Variable(list.get(i)));
                }
            } else if (var.type == Variable.Type.MAP) {
                Map map = (Map)var.getValue();
                for (Map.Entry entry : map.entrySet()) {
                    vars.put((String)entry.getKey(), new Variable(entry.getValue()));
                }
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        String finalParentExpression = parentExpression;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        vars.forEach((k, v) -> {
            if (v != null) {
                String pathExpression;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", k);
                try {
                    map.put("value", v.getAsString());
                }
                catch (Exception e) {
                    logger.warn("unable to convert to string: {} - {}", k, v);
                    map.put("value", "(unknown)");
                }
                map.put("type", v.type.name());
                String string = pathExpression = k.startsWith("[") ? finalParentExpression.replaceAll("\\.$", "") : finalParentExpression;
                if (v.type == Variable.Type.LIST || v.type == Variable.Type.MAP) {
                    this.VARIABLES.put(++this.nextVariablesReference, new AbstractMap.SimpleEntry<CallSite, Variable>((CallSite)((Object)(pathExpression + k + ".")), (Variable)v));
                    map.put("presentationHint", "data");
                    map.put("variablesReference", this.nextVariablesReference);
                } else {
                    map.put("variablesReference", 0);
                }
                map.put("evaluateName", pathExpression + k);
                list.add(map);
            }
        });
        Collections.sort(list, (a, b) -> ((String)a.get("name")).compareTo((String)b.get("name")));
        return list;
    }

    private DapMessage event(String name) {
        return DapMessage.event(++this.nextSeq, name);
    }

    private DapMessage response(DapMessage req) {
        return DapMessage.response(++this.nextSeq, req);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DapMessage dm) throws Exception {
        switch (dm.type) {
            case REQUEST: {
                this.handleRequest(dm, ctx);
                break;
            }
            default: {
                logger.warn("ignoring message: {}", (Object)dm);
            }
        }
    }

    private void handleRequest(DapMessage req, ChannelHandlerContext ctx) {
        switch (req.command) {
            case "initialize": {
                ctx.write(this.response(req).body("supportsConfigurationDoneRequest", true).body("supportsRestartRequest", true).body("supportsStepBack", true).body("supportsVariableType", true).body("supportsValueFormattingOptions", true).body("supportsClipboardContext", true));
                ctx.write(this.event("initialized"));
                ctx.write(this.event("output").body("output", "debug server listening on port: " + this.server.getPort() + "\n"));
                break;
            }
            case "setBreakpoints": {
                SourceBreakpoints sb = new SourceBreakpoints(req.getArguments());
                this.BREAKPOINTS.put(this.normalizePath(sb.path), sb);
                logger.trace("source breakpoints: {}", (Object)sb);
                ctx.write(this.response(req).body("breakpoints", sb.getBreakpointsAsListOfMaps()));
                break;
            }
            case "launch": {
                this.launchArgs = req.getArgument("karateArgs", List.class);
                this.launchCommand = StringUtils.trimToEmpty((String)req.getArgument("karateOptions", String.class));
                String feature = StringUtils.trimToNull((String)req.getArgument("feature", String.class));
                if (feature != null) {
                    if (this.launchArgs != null) {
                        this.launchArgs.add(feature);
                    } else {
                        this.launchCommand = this.launchCommand + " " + feature;
                    }
                }
                this.preStep = StringUtils.trimToNull((String)req.getArgument("debugPreStep", String.class));
                if (this.preStep != null) {
                    logger.debug("using pre-step: {}", (Object)this.preStep);
                }
                this.start();
                ctx.write(this.response(req));
                break;
            }
            case "threads": {
                ArrayList list = new ArrayList(this.THREADS.size());
                this.THREADS.values().forEach(v -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", v.id);
                    map.put("name", v.name);
                    list.add(map);
                });
                ctx.write(this.response(req).body("threads", list));
                break;
            }
            case "stackTrace": {
                ctx.write(this.response(req).body("stackFrames", this.frames(req.getThreadId())));
                break;
            }
            case "configurationDone": {
                ctx.write(this.response(req));
                break;
            }
            case "scopes": {
                Number frameId = req.getArgument("frameId", Number.class);
                HashMap<String, Object> scope = new HashMap<String, Object>();
                scope.put("name", "In Scope");
                scope.put("variablesReference", frameId);
                scope.put("presentationHint", "locals");
                scope.put("expensive", false);
                ctx.write(this.response(req).body("scopes", Collections.singletonList(scope)));
                break;
            }
            case "variables": {
                Integer variablesReference = req.getArgument("variablesReference", Integer.class);
                ctx.write(this.response(req).body("variables", this.variables(variablesReference.longValue())));
                break;
            }
            case "next": {
                this.thread(req).next().resume();
                ctx.write(this.response(req));
                break;
            }
            case "stepBack": 
            case "reverseContinue": {
                this.thread(req).stepBack().resume();
                ctx.write(this.response(req));
                break;
            }
            case "stepIn": {
                this.thread(req).stepIn().resume();
                ctx.write(this.response(req));
                break;
            }
            case "stepOut": {
                this.thread(req).stepOut().resume();
                ctx.write(this.response(req));
                break;
            }
            case "continue": {
                this.thread(req)._continue().resume();
                ctx.write(this.response(req));
                break;
            }
            case "pause": {
                ctx.write(this.response(req));
                this.thread(req).pause();
                break;
            }
            case "evaluate": {
                Object result;
                String expression = req.getArgument("expression", String.class);
                Number evalFrameId = req.getArgument("frameId", Number.class);
                String reqContext = req.getArgument("context", String.class);
                ScenarioRuntime evalContext = this.FRAMES.get(evalFrameId.longValue());
                if ("clipboard".equals(reqContext) || "hover".equals(reqContext)) {
                    result = this.evaluateVarExpression(evalContext.engine.vars, expression);
                } else {
                    ScenarioEngine.set((ScenarioEngine)evalContext.engine);
                    this.evaluatePreStep(evalContext);
                    Throwable engineFailedReason = evalContext.engine.getFailedReason();
                    evalContext.engine.setFailedReason(null);
                    Result evalResult = evalContext.evalAsStep(expression);
                    result = evalResult.isFailed() ? "[error] " + evalResult.getError().getMessage() : "[done]";
                    evalContext.engine.setFailedReason(engineFailedReason);
                }
                ctx.write(this.response(req).body("result", result).body("variablesReference", 0));
                break;
            }
            case "restart": {
                ScenarioRuntime context = this.FRAMES.get(this.focusedFrameId);
                if (context != null && context.hotReload()) {
                    this.output("[debug] hot reload successful");
                } else {
                    this.output("[debug] hot reload requested, but no steps edited");
                }
                ctx.write(this.response(req));
                break;
            }
            case "disconnect": {
                boolean restart = req.getArgument("restart", Boolean.class);
                if (restart) {
                    this.start();
                } else {
                    this.exit();
                }
                ctx.write(this.response(req));
                break;
            }
            default: {
                logger.warn("unknown command: {}", (Object)req);
                ctx.write(this.response(req));
            }
        }
        ctx.writeAndFlush(Unpooled.EMPTY_BUFFER);
    }

    protected String evaluateVarExpression(Map<String, Variable> vars, String expression) {
        Object result = "";
        try {
            if (expression.contains(".")) {
                String varName = expression.substring(0, expression.indexOf(46));
                String path = expression.substring(expression.indexOf(46) + 1);
                Object nested = Json.of((Object)vars.get(varName).getValue()).get(path);
                result = JsonUtils.toJsonSafe((Object)nested, (boolean)true);
            } else {
                Variable v = vars.get(expression);
                result = v.getAsPrettyString();
            }
        }
        catch (Exception e) {
            result = "[error] " + e.getMessage();
        }
        return result;
    }

    protected void evaluatePreStep(ScenarioRuntime context) {
        if (this.preStep == null) {
            return;
        }
        Result result = context.evalAsStep(this.preStep);
        if (result.isFailed()) {
            this.output("[debug] pre-step failed: " + this.preStep + " - " + result.getError().getMessage());
        } else {
            this.output("[debug] pre-step success: " + this.preStep);
        }
    }

    public RuntimeHook create() {
        return new DebugThread(Thread.currentThread(), this);
    }

    private void start() {
        Main options;
        if (this.launchArgs != null) {
            logger.debug("command args: {}", this.launchArgs);
            options = Main.parseKarateArgs(this.launchArgs);
        } else {
            logger.debug("command line: {}", (Object)this.launchCommand);
            options = IdeMain.parseIdeCommandLine((String)this.launchCommand);
        }
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
        }
        this.runnerThread = new Thread(() -> {
            Runner.path((List)options.getPaths()).debugMode(true).hookFactory((RuntimeHookFactory)this).hooks(options.createHooks()).tags(options.getTags()).configDir(options.getConfigDir()).karateEnv(options.getEnv()).outputHtmlReport(options.isOutputHtmlReport()).outputCucumberJson(options.isOutputCucumberJson()).outputJunitXml(options.isOutputJunitXml()).scenarioName(options.getName()).parallel(options.getThreads());
            this.exit();
        });
        this.runnerThread.start();
    }

    protected void stopEvent(long threadId, String reason, String description, List<Integer> breakPointIds) {
        this.channel.eventLoop().execute(() -> {
            DapMessage message = this.event("stopped").body("reason", reason).body("threadId", threadId);
            if (description != null) {
                message.body("description", description);
            }
            if (breakPointIds != null) {
                message.body("hitBreakpointIds", breakPointIds);
            }
            this.channel.writeAndFlush(message);
        });
    }

    protected void continueEvent(long threadId) {
        this.channel.eventLoop().execute(() -> {
            DapMessage message = this.event("continued").body("threadId", threadId);
            this.channel.writeAndFlush(message);
        });
    }

    private void exit() {
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush(this.event("exited").body("exitCode", 0)));
        this.server.stop();
    }

    private void clearDebugSession() {
        this.BREAKPOINTS.clear();
        this.THREADS.clear();
        this.FRAMES.clear();
        this.FRAME_VARS.clear();
        this.VARIABLES.clear();
        this.launchCommand = null;
        this.preStep = null;
        if (this.runnerThread != null && this.runnerThread.isAlive()) {
            this.runnerThread.interrupt();
        }
    }

    protected long nextFrameId() {
        return ++this.nextFrameId;
    }

    protected void output(String text) {
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush(this.event("output").body("output", text)));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.channel = ctx.channel();
    }
}

