/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import com.intuit.karate.LogAppender;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Variable;
import io.karatelabs.debug.Breakpoint;
import io.karatelabs.debug.DapServerHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugThread
implements RuntimeHook,
LogAppender {
    private static final Logger logger = LoggerFactory.getLogger(DebugThread.class);
    public final long id;
    public final String name;
    public final Thread thread;
    public final Stack<Long> stack = new Stack();
    private final Map<Integer, Boolean> stepModes = new HashMap<Integer, Boolean>();
    public final DapServerHandler handler;
    private boolean stepIn;
    private boolean stepBack;
    private boolean paused;
    private boolean interrupted;
    private boolean stopped;
    private boolean errored;
    private final String appenderPrefix;
    private LogAppender appender = LogAppender.NO_OP;

    public DebugThread(Thread thread, DapServerHandler handler) {
        this.id = thread.getId();
        this.name = thread.getName();
        this.appenderPrefix = "[" + this.name + "] ";
        this.thread = thread;
        this.handler = handler;
    }

    protected void pause() {
        this.paused = true;
    }

    private boolean stop(String reason) {
        return this.stop(reason, null);
    }

    private boolean stop(String reason, List<Integer> breakPointIds) {
        return this.stop(reason, null, breakPointIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop(String reason, String description, List<Integer> breakPointIds) {
        this.handler.stopEvent(this.id, reason, description, breakPointIds);
        this.stopped = true;
        DebugThread debugThread = this;
        synchronized (debugThread) {
            try {
                this.wait();
            }
            catch (Exception e) {
                logger.warn("thread error: {}", (Object)e.getMessage());
                this.interrupted = true;
                return false;
            }
        }
        this.handler.continueEvent(this.id);
        if (this.stepBack) {
            this.getContext().stepBack();
            return false;
        }
        if (this.stopped) {
            this.getContext().stepReset();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        this.stopped = false;
        this.handler.evaluatePreStep(this.getContext());
        Iterator<DebugThread> iterator = this.handler.THREADS.values().iterator();
        while (iterator.hasNext()) {
            DebugThread dt;
            DebugThread debugThread = dt = iterator.next();
            synchronized (debugThread) {
                dt.notify();
            }
        }
    }

    public boolean beforeScenario(ScenarioRuntime context) {
        long frameId = this.handler.nextFrameId();
        this.stack.push(frameId);
        this.handler.FRAMES.put(frameId, context);
        this.handler.FRAME_VARS.put(frameId, new Stack());
        if (context.caller.depth == 0) {
            this.handler.THREADS.put(this.id, this);
        }
        this.appender = context.getLogAppender();
        context.logger.setAppender((LogAppender)this);
        return true;
    }

    public void afterScenario(ScenarioRuntime context) {
        this.stack.pop();
        if (context.caller.depth == 0) {
            this.handler.THREADS.remove(this.id);
        }
        context.logger.setAppender(this.appender);
    }

    public boolean beforeStep(Step step, ScenarioRuntime context) {
        if (this.interrupted) {
            return false;
        }
        if (this.paused) {
            this.paused = false;
            return this.stop("pause");
        }
        if (this.errored) {
            this.errored = false;
            if (this.isStepMode()) {
                context.stepProceed();
                return false;
            }
            context.stepReset();
            return false;
        }
        if (this.stepBack) {
            this.stepBack = false;
            return this.stop("step");
        }
        if (this.stepIn) {
            this.stepIn = false;
            return this.stop("step");
        }
        if (this.isStepMode()) {
            return this.stop("step");
        }
        int line = step.getLine();
        Breakpoint sb = this.handler.resolveBreakpoint(step, line, context);
        if (sb != null) {
            return this.stop("breakpoint", Collections.singletonList(sb.id));
        }
        return true;
    }

    public void afterStep(StepResult result, ScenarioRuntime context) {
        if (result.getResult().isFailed()) {
            String errorMessage = result.getErrorMessage();
            this.handler.output("*** step failed: " + errorMessage + "\n");
            this.stop("exception", errorMessage, null);
            this.errored = true;
        }
        this.pushDebugFrameVariables(context);
    }

    private void pushDebugFrameVariables(ScenarioRuntime context) {
        Map<String, Variable> vars = context.engine.vars.entrySet().stream().collect(Collectors.toMap(v -> (String)v.getKey(), v -> ((Variable)v.getValue()).copy(true)));
        Stack<Map<String, Variable>> stackVars = this.handler.FRAME_VARS.get(this.stack.peek());
        if (stackVars != null) {
            stackVars.push(vars);
        }
    }

    private void popDebugFrameVariables() {
        this.handler.FRAME_VARS.get(this.stack.peek()).pop();
    }

    private ScenarioRuntime getContext() {
        return this.handler.FRAMES.get(this.stack.peek());
    }

    protected DebugThread _continue() {
        this.stepModes.clear();
        return this;
    }

    protected DebugThread next() {
        this.stepModes.put(this.stack.size(), true);
        return this;
    }

    protected DebugThread stepOut() {
        int stackSize = this.stack.size();
        this.stepModes.put(stackSize, false);
        if (stackSize > 1) {
            this.stepModes.put(stackSize - 1, true);
        }
        return this;
    }

    protected boolean isStepMode() {
        Boolean stepMode = this.stepModes.get(this.stack.size());
        return stepMode == null ? false : stepMode;
    }

    protected DebugThread stepIn() {
        this.stepIn = true;
        return this;
    }

    protected DebugThread stepBack() {
        this.popDebugFrameVariables();
        this.stepBack = true;
        return this;
    }

    public LogAppender getAppender() {
        return this.appender;
    }

    public void setAppender(LogAppender appender) {
        this.appender = appender;
    }

    public String getBuffer() {
        return this.appender.getBuffer();
    }

    public String collect() {
        return this.appender.collect();
    }

    public void append(String text) {
        this.handler.output(this.appenderPrefix + text);
        this.appender.append(text);
    }

    public void close() {
    }

    public String toString() {
        return "id: " + this.id + ", name: " + this.name + ", stack: " + this.stack;
    }
}

