/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import com.intuit.karate.Json;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Variable;
import io.karatelabs.debug.Breakpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SourceBreakpoints {
    public final String name;
    public final String path;
    public final List<Breakpoint> breakpoints;
    public final boolean sourceModified;

    public Breakpoint resolveBreakpoint(int line, ScenarioRuntime context) {
        if (this.breakpoints == null || this.breakpoints.isEmpty()) {
            return null;
        }
        for (Breakpoint b : this.breakpoints) {
            if (b.line != line) continue;
            if (b.condition == null) {
                return b;
            }
            Variable evalCondition = context.engine.evalKarateExpression(b.condition);
            if (evalCondition != null && evalCondition.type != Variable.Type.BOOLEAN) {
                return b;
            }
            if (evalCondition == null || !evalCondition.isTrue()) continue;
            return b;
        }
        return null;
    }

    public SourceBreakpoints(Map<String, Object> map) {
        Json json = Json.of(map);
        this.name = (String)json.get("source.name");
        this.path = (String)json.get("source.path");
        List list = (List)json.get("breakpoints");
        this.breakpoints = new ArrayList<Breakpoint>(list.size());
        for (Map bm : list) {
            this.breakpoints.add(new Breakpoint(bm));
        }
        this.sourceModified = (Boolean)json.get("sourceModified");
    }

    public List<Map> getBreakpointsAsListOfMaps() {
        ArrayList<Map> list = new ArrayList<Map>(this.breakpoints.size());
        for (Breakpoint b : this.breakpoints) {
            list.add(b.toMap());
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[name: ").append(this.name);
        sb.append(", path: ").append(this.path);
        sb.append(", breakpoints: ").append(this.breakpoints);
        sb.append(", sourceModified: ").append(this.sourceModified);
        sb.append("]");
        return sb.toString();
    }
}

