/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class StackFrame {
    private final long id;
    private final int line;
    private final int column = 0;
    private final String name;
    private final Map<String, Object> source = new HashMap<String, Object>();

    public StackFrame(long frameId, ScenarioRuntime context) {
        this.id = frameId;
        Step step = context.getCurrentStep();
        this.line = step.getLine();
        Scenario scenario = context.scenario;
        this.name = scenario.getRefId();
        File file = scenario.getFeature().getResource().getFile();
        this.source.put("name", file.getName());
        this.source.put("path", file.getPath());
        this.source.put("sourceReference", 0);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("line", this.line);
        map.put("column", 0);
        map.put("name", this.name);
        map.put("source", this.source);
        return map;
    }
}

