/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.gatling.javaapi;

import com.intuit.karate.gatling.MethodPause;
import com.intuit.karate.gatling.javaapi.KarateDsl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class KarateUriPattern {
    final String uri;
    final List<MethodPause> pauses;

    KarateUriPattern(String uri, List<MethodPause> pauses) {
        this.uri = uri;
        this.pauses = pauses;
    }

    String getUri() {
        return this.uri;
    }

    List<MethodPause> getPauses() {
        return this.pauses;
    }

    public static class KarateUriPatternBuilder {
        private final String uri;

        KarateUriPatternBuilder(String uri) {
            this.uri = uri;
        }

        public KarateUriPattern nil() {
            return new KarateUriPattern(this.uri, Collections.emptyList());
        }

        public KarateUriPattern pauseFor(String method, int durationInMillis) {
            return this.pauseFor(KarateDsl.method(method, durationInMillis));
        }

        public KarateUriPattern pauseFor(String method1, int durationInMillis1, String method2, int durationInMillis2) {
            return this.pauseFor(KarateDsl.method(method1, durationInMillis1), KarateDsl.method(method2, durationInMillis2));
        }

        public KarateUriPattern pauseFor(MethodPause ... pauses) {
            return new KarateUriPattern(this.uri, Arrays.asList(pauses));
        }
    }
}

