/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.Runner;
import com.intuit.karate.Suite;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.junit5.FeatureNode;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.TestFactory;

public class Karate
extends Runner.Builder<Karate>
implements Iterable<DynamicNode> {
    public static Karate run(String ... paths) {
        return (Karate)new Karate().path(paths);
    }

    @Override
    public Iterator<DynamicNode> iterator() {
        Suite suite = new Suite((Runner.Builder)this);
        ArrayList<DynamicContainer> list = new ArrayList<DynamicContainer>();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (FeatureCall featureCall : suite.features) {
            FeatureNode featureNode = new FeatureNode(suite, futures, featureCall, suite.tagSelector);
            if (!featureNode.hasNext()) continue;
            String testName = featureCall.feature.getResource().getFileNameWithoutExtension();
            DynamicContainer node = DynamicContainer.dynamicContainer((String)testName, (Iterable)featureNode);
            list.add(node);
        }
        if (suite.failWhenNoScenariosFound && list.isEmpty()) {
            Assertions.fail((String)("no features or scenarios found: " + String.valueOf(this)));
        }
        return list.iterator();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestFactory
    public static @interface Test {
    }
}

