/*
 * Decompiled with CFR 0.152.
 */
package io.karim;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.util.Property;
import io.karim.Utils;
import io.karim.materialtabs.R;

public class MaterialRippleLayout
extends FrameLayout {
    private static final String TAG = MaterialRippleLayout.class.getSimpleName();
    public static final int DEFAULT_DURATION = 250;
    public static final int DEFAULT_FADE_DURATION = 125;
    public static final float DEFAULT_DIAMETER_DP = 20.0f;
    public static final float DEFAULT_ALPHA = 0.2f;
    public static final int DEFAULT_COLOR = -1;
    public static final boolean DEFAULT_DELAY_CLICK = false;
    public static final boolean DEFAULT_PERSISTENT = false;
    public static final boolean DEFAULT_SEARCH_ADAPTER = false;
    public static final boolean DEFAULT_RIPPLE_OVERLAY = false;
    public static final int DEFAULT_ROUNDED_CORNERS_DP = 0;
    public static final int FADE_EXTRA_DELAY = 50;
    public static final long HOVER_DURATION = 2500L;
    private final Paint paint = new Paint(1);
    private final Rect bounds = new Rect();
    private int rippleColor;
    private int rippleHighlightColor;
    private boolean rippleOverlay;
    private int rippleDiameterPx;
    private int rippleDuration;
    private int rippleAlphaInt;
    private boolean rippleDelayClick;
    private int rippleFadeDuration;
    private boolean ripplePersistent;
    private boolean rippleInAdapter;
    private float rippleRoundedCornersPx;
    private float radius;
    private AdapterView parentAdapter;
    private View childView;
    private AnimatorSet rippleAnimator;
    private ObjectAnimator hoverAnimator;
    private Point currentCoordinates = new Point();
    private Point previousCoordinates = new Point();
    private int layerType;
    private boolean eventCancelled;
    private boolean prepressed;
    private int positionInAdapter;
    private final GestureDetector gestureDetector;
    private PressedEvent pendingPressEvent;
    private final Property<MaterialRippleLayout, Float> radiusProperty = new Property<MaterialRippleLayout, Float>(Float.class, "radius"){

        public Float get(MaterialRippleLayout object) {
            return Float.valueOf(object.getRadius());
        }

        public void set(MaterialRippleLayout object, Float value) {
            object.setRadius(value.floatValue());
        }
    };
    private boolean mHasPerformedLongPress;
    private final Property<MaterialRippleLayout, Integer> circleAlphaProperty = new Property<MaterialRippleLayout, Integer>(Integer.class, "rippleAlphaFloat"){

        public Integer get(MaterialRippleLayout object) {
            return object.getRippleAlphaInt();
        }

        public void set(MaterialRippleLayout object, Integer value) {
            object.setRippleAlphaInt(value);
        }
    };

    public static RippleBuilder on(View view) {
        return new RippleBuilder(view);
    }

    public MaterialRippleLayout(Context context) {
        this(context, null, 0);
    }

    public MaterialRippleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public final void addView(@NonNull View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("MaterialRippleLayout can host only one child");
        }
        this.childView = child;
        super.addView(child, index, params);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        if (this.childView == null) {
            throw new IllegalStateException("MaterialRippleLayout must have a child view to handle clicks");
        }
        this.childView.setOnClickListener(onClickListener);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return !this.findClickableViewInChild(this.childView, (int)event.getX(), (int)event.getY());
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean gestureResult;
        boolean superOnTouchEvent = super.onTouchEvent(event);
        if (!this.isEnabled() || !this.childView.isEnabled()) {
            return superOnTouchEvent;
        }
        boolean isEventInBounds = this.bounds.contains((int)event.getX(), (int)event.getY());
        if (isEventInBounds) {
            this.previousCoordinates.set(this.currentCoordinates.x, this.currentCoordinates.y);
            this.currentCoordinates.set((int)event.getX(), (int)event.getY());
        }
        if ((gestureResult = this.gestureDetector.onTouchEvent(event)) || this.mHasPerformedLongPress) {
            return true;
        }
        int action = event.getActionMasked();
        switch (action) {
            case 1: {
                if (this.prepressed) {
                    this.childView.setPressed(true);
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MaterialRippleLayout.this.childView.setPressed(false);
                        }
                    }, ViewConfiguration.getPressedStateDuration());
                }
                if (isEventInBounds) {
                    PerformClickEvent pendingClickEvent = new PerformClickEvent();
                    this.startRipple(pendingClickEvent);
                    if (!this.rippleDelayClick) {
                        pendingClickEvent.run();
                    }
                }
                this.cancelPressedEvent();
                break;
            }
            case 0: {
                this.setBackgroundColor(this.rippleHighlightColor);
                this.setPositionInAdapter();
                this.eventCancelled = false;
                this.pendingPressEvent = new PressedEvent(event);
                if (this.isInScrollingContainer()) {
                    this.cancelPressedEvent();
                    this.prepressed = true;
                    this.postDelayed(this.pendingPressEvent, ViewConfiguration.getTapTimeout());
                    break;
                }
                this.pendingPressEvent.run();
                break;
            }
            case 3: {
                if (this.rippleInAdapter) {
                    this.currentCoordinates.set(this.previousCoordinates.x, this.previousCoordinates.y);
                    this.previousCoordinates = new Point();
                }
                this.childView.onTouchEvent(event);
                this.startRipple(null);
                this.cancelPressedEvent();
                break;
            }
            case 2: {
                this.setBackgroundColor(this.rippleHighlightColor);
                if (isEventInBounds && !this.eventCancelled) {
                    this.invalidate();
                } else if (!isEventInBounds) {
                    this.startRipple(null);
                }
                if (isEventInBounds) break;
                this.cancelPressedEvent();
                if (this.hoverAnimator != null) {
                    this.hoverAnimator.cancel();
                }
                this.childView.onTouchEvent(event);
                this.eventCancelled = true;
            }
        }
        return true;
    }

    private void cancelPressedEvent() {
        if (this.pendingPressEvent != null) {
            this.removeCallbacks(this.pendingPressEvent);
            this.prepressed = false;
        }
    }

    private void startHover() {
        if (this.eventCancelled) {
            return;
        }
        if (this.hoverAnimator != null) {
            this.hoverAnimator.cancel();
        }
        float radius = (float)(Math.sqrt(Math.pow(this.getWidth(), 2.0) + Math.pow(this.getHeight(), 2.0)) * (double)1.2f);
        this.hoverAnimator = ObjectAnimator.ofFloat((Object)((Object)this), this.radiusProperty, (float[])new float[]{this.rippleDiameterPx, radius}).setDuration(2500L);
        this.hoverAnimator.setInterpolator((Interpolator)new LinearInterpolator());
        this.hoverAnimator.start();
    }

    private void startRipple(final Runnable animationEndRunnable) {
        if (this.eventCancelled) {
            return;
        }
        float endRadius = this.getEndRadius();
        this.cancelAnimations();
        this.rippleAnimator = new AnimatorSet();
        this.rippleAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!MaterialRippleLayout.this.ripplePersistent) {
                    MaterialRippleLayout.this.setRadius(0.0f);
                    MaterialRippleLayout.this.setRippleAlphaInt(MaterialRippleLayout.this.rippleAlphaInt);
                }
                if (animationEndRunnable != null && MaterialRippleLayout.this.rippleDelayClick) {
                    animationEndRunnable.run();
                }
                MaterialRippleLayout.this.childView.setPressed(false);
                MaterialRippleLayout.this.setBackgroundColor(0);
            }
        });
        ObjectAnimator ripple = ObjectAnimator.ofFloat((Object)((Object)this), this.radiusProperty, (float[])new float[]{this.radius, endRadius});
        ripple.setDuration((long)this.rippleDuration);
        ripple.setInterpolator((Interpolator)new DecelerateInterpolator());
        ObjectAnimator fade = ObjectAnimator.ofInt((Object)((Object)this), this.circleAlphaProperty, (int[])new int[]{this.rippleAlphaInt, 0});
        fade.setDuration((long)this.rippleFadeDuration);
        fade.setInterpolator((Interpolator)new AccelerateInterpolator());
        fade.setStartDelay((long)(this.rippleDuration - this.rippleFadeDuration - 50));
        if (this.ripplePersistent) {
            this.rippleAnimator.play((Animator)ripple);
        } else if (this.getRadius() > endRadius) {
            fade.setStartDelay(0L);
            this.rippleAnimator.play((Animator)fade);
        } else {
            this.rippleAnimator.playTogether(new Animator[]{ripple, fade});
        }
        this.rippleAnimator.start();
    }

    private void cancelAnimations() {
        if (this.rippleAnimator != null) {
            this.rippleAnimator.cancel();
            this.rippleAnimator.removeAllListeners();
        }
        if (this.hoverAnimator != null) {
            this.hoverAnimator.cancel();
        }
    }

    private boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (Build.VERSION.SDK_INT < 14 || !((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    private AdapterView findParentAdapterView() {
        if (this.parentAdapter != null) {
            return this.parentAdapter;
        }
        ViewParent current = this.getParent();
        while (true) {
            if (current instanceof AdapterView) {
                this.parentAdapter = (AdapterView)current;
                return this.parentAdapter;
            }
            try {
                current = current.getParent();
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("Could not find a parent AdapterView");
            }
        }
    }

    private void setPositionInAdapter() {
        if (this.rippleInAdapter) {
            this.positionInAdapter = this.findParentAdapterView().getPositionForView((View)this);
        }
    }

    private boolean adapterPositionChanged() {
        if (this.rippleInAdapter) {
            int newPosition = this.findParentAdapterView().getPositionForView((View)this);
            boolean changed = newPosition != this.positionInAdapter;
            this.positionInAdapter = newPosition;
            if (changed) {
                this.cancelPressedEvent();
                this.cancelAnimations();
                this.childView.setPressed(false);
                this.setRadius(0.0f);
            }
            return changed;
        }
        return false;
    }

    private boolean findClickableViewInChild(View view, int x, int y) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                Rect rect = new Rect();
                child.getHitRect(rect);
                boolean contains = rect.contains(x, y);
                if (!contains) continue;
                return this.findClickableViewInChild(child, x - rect.left, y - rect.top);
            }
        } else if (view != this.childView) {
            return view.isEnabled() && (view.isClickable() || view.isLongClickable() || view.isFocusableInTouchMode());
        }
        return view.isFocusableInTouchMode();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.bounds.set(0, 0, w, h);
    }

    public boolean isInEditMode() {
        return true;
    }

    public void draw(@NonNull Canvas canvas) {
        boolean positionChanged = this.adapterPositionChanged();
        if (this.rippleOverlay) {
            super.draw(canvas);
            if (!positionChanged) {
                if (this.rippleRoundedCornersPx != 0.0f) {
                    Path clipPath = new Path();
                    RectF rect = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
                    clipPath.addRoundRect(rect, this.rippleRoundedCornersPx, this.rippleRoundedCornersPx, Path.Direction.CW);
                    canvas.clipPath(clipPath);
                }
                canvas.drawCircle((float)this.currentCoordinates.x, (float)this.currentCoordinates.y, this.radius, this.paint);
            }
        } else {
            if (!positionChanged) {
                canvas.drawCircle((float)this.currentCoordinates.x, (float)this.currentCoordinates.y, this.radius, this.paint);
            }
            super.draw(canvas);
        }
    }

    public MaterialRippleLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent e) {
                MaterialRippleLayout.this.mHasPerformedLongPress = MaterialRippleLayout.this.childView.performLongClick();
                if (MaterialRippleLayout.this.mHasPerformedLongPress) {
                    MaterialRippleLayout.this.startRipple(null);
                    MaterialRippleLayout.this.cancelPressedEvent();
                }
            }

            public boolean onDown(MotionEvent e) {
                MaterialRippleLayout.this.mHasPerformedLongPress = false;
                return super.onDown(e);
            }
        });
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MaterialRippleLayout);
        this.rippleColor = a.getColor(R.styleable.MaterialRippleLayout_mrlRippleColor, -1);
        this.rippleHighlightColor = Color.argb((int)((int)((double)Color.alpha((int)this.rippleColor) * 0.25)), (int)Color.red((int)this.rippleColor), (int)Color.green((int)this.rippleColor), (int)Color.blue((int)this.rippleColor));
        this.rippleHighlightColor = a.getColor(R.styleable.MaterialRippleLayout_mrlRippleHighlightColor, this.rippleHighlightColor);
        this.rippleDiameterPx = a.getDimensionPixelSize(R.styleable.MaterialRippleLayout_mrlRippleDiameter, Utils.dpToPx(this.getResources(), 20.0f));
        this.rippleOverlay = a.getBoolean(R.styleable.MaterialRippleLayout_mrlRippleOverlay, false);
        this.rippleDuration = a.getInt(R.styleable.MaterialRippleLayout_mrlRippleDuration, 250);
        this.rippleAlphaInt = (int)(255.0f * a.getFloat(R.styleable.MaterialRippleLayout_mrlRippleAlpha, 0.2f));
        this.rippleDelayClick = a.getBoolean(R.styleable.MaterialRippleLayout_mrlRippleDelayClick, false);
        this.rippleFadeDuration = a.getInteger(R.styleable.MaterialRippleLayout_mrlRippleFadeDuration, 125);
        this.ripplePersistent = a.getBoolean(R.styleable.MaterialRippleLayout_mrlRipplePersistent, false);
        this.rippleInAdapter = a.getBoolean(R.styleable.MaterialRippleLayout_mrlRippleInAdapter, false);
        this.rippleRoundedCornersPx = a.getDimensionPixelSize(R.styleable.MaterialRippleLayout_mrlRippleRoundedCorners, 0);
        a.recycle();
        this.paint.setColor(this.rippleColor);
        this.paint.setAlpha(this.rippleAlphaInt);
        this.enableClipPathSupportIfNecessary();
    }

    private float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidate();
    }

    private float getEndRadius() {
        int width = this.getWidth();
        int height = this.getHeight();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        float radiusX = halfWidth > this.currentCoordinates.x ? (float)(width - this.currentCoordinates.x) : (float)this.currentCoordinates.x;
        float radiusY = halfHeight > this.currentCoordinates.y ? (float)(height - this.currentCoordinates.y) : (float)this.currentCoordinates.y;
        return (float)Math.sqrt(Math.pow(radiusX, 2.0) + Math.pow(radiusY, 2.0)) * 1.2f;
    }

    public int getRippleAlphaInt() {
        return this.paint.getAlpha();
    }

    public void setRippleAlphaInt(Integer alphaInt) {
        this.paint.setAlpha(alphaInt.intValue());
        this.invalidate();
    }

    public void setRippleColor(int rippleColor) {
        this.rippleColor = rippleColor;
        this.rippleHighlightColor = Color.argb((int)((int)((double)Color.alpha((int)rippleColor) * 0.25)), (int)Color.red((int)rippleColor), (int)Color.green((int)rippleColor), (int)Color.blue((int)rippleColor));
        this.paint.setColor(rippleColor);
        this.paint.setAlpha(this.rippleAlphaInt);
        this.invalidate();
    }

    public void setRippleHighlightColor(int rippleHighlightColor) {
        this.rippleHighlightColor = rippleHighlightColor;
        this.invalidate();
    }

    public void setRippleOverlay(boolean rippleOverlay) {
        this.rippleOverlay = rippleOverlay;
    }

    public void setRippleDiameterPx(int rippleDiameterPx) {
        this.rippleDiameterPx = rippleDiameterPx;
    }

    public void setRippleDuration(int rippleDuration) {
        this.rippleDuration = rippleDuration;
    }

    public void setRippleDelayClick(boolean rippleDelayClick) {
        this.rippleDelayClick = rippleDelayClick;
    }

    public void setRippleFadeDuration(int rippleFadeDuration) {
        this.rippleFadeDuration = rippleFadeDuration;
    }

    public void setRipplePersistent(boolean ripplePersistent) {
        this.ripplePersistent = ripplePersistent;
    }

    public void setRippleInAdapter(boolean rippleInAdapter) {
        this.rippleInAdapter = rippleInAdapter;
    }

    public void setRippleRoundedCornersPx(int rippleRoundedCornerPx) {
        this.rippleRoundedCornersPx = rippleRoundedCornerPx;
        this.enableClipPathSupportIfNecessary();
    }

    public void setDefaultRippleAlphaInt(int alphaInt) {
        this.rippleAlphaInt = alphaInt;
        this.paint.setAlpha(alphaInt);
        this.invalidate();
    }

    public void performRipple() {
        this.currentCoordinates = new Point(this.getWidth() / 2, this.getHeight() / 2);
        this.startRipple(null);
    }

    public void performRipple(Point anchor) {
        this.currentCoordinates = new Point(anchor.x, anchor.y);
        this.startRipple(null);
    }

    private void enableClipPathSupportIfNecessary() {
        if (Build.VERSION.SDK_INT <= 17 && Build.VERSION.SDK_INT >= 11) {
            if (this.rippleRoundedCornersPx != 0.0f) {
                this.layerType = this.getLayerType();
                this.setLayerType(1, null);
            } else {
                this.setLayerType(this.layerType, null);
            }
        }
    }

    public static class RippleBuilder {
        private final Context context;
        private final View child;
        private int rippleColor = -1;
        private int rippleHighlightColor;
        private boolean rippleOverlay = false;
        private float rippleDiameterDp = 20.0f;
        private int rippleDuration = 250;
        private float rippleAlphaFloat = 0.2f;
        private boolean rippleDelayClick = false;
        private int rippleFadeDuration = 125;
        private boolean ripplePersistent = false;
        private boolean rippleSearchAdapter = false;
        private float rippleRoundedCornerDp = 0.0f;

        public RippleBuilder(View child) {
            this.child = child;
            this.context = child.getContext();
        }

        public RippleBuilder rippleColor(int color) {
            this.rippleColor = color;
            this.rippleHighlightColor = Color.argb((int)((int)((double)Color.alpha((int)this.rippleColor) * 0.25)), (int)Color.red((int)this.rippleColor), (int)Color.green((int)this.rippleColor), (int)Color.blue((int)this.rippleColor));
            return this;
        }

        public RippleBuilder rippleHighlightColor(int highlightColor) {
            this.rippleHighlightColor = highlightColor;
            return this;
        }

        public RippleBuilder rippleOverlay(boolean overlay) {
            this.rippleOverlay = overlay;
            return this;
        }

        public RippleBuilder rippleDiameterDp(float diameterDp) {
            this.rippleDiameterDp = diameterDp;
            return this;
        }

        public RippleBuilder rippleDuration(int duration) {
            this.rippleDuration = duration;
            return this;
        }

        public RippleBuilder rippleAlpha(float alpha) {
            this.rippleAlphaFloat = alpha;
            return this;
        }

        public RippleBuilder rippleDelayClick(boolean delayClick) {
            this.rippleDelayClick = delayClick;
            return this;
        }

        public RippleBuilder rippleFadeDuration(int fadeDuration) {
            this.rippleFadeDuration = fadeDuration;
            return this;
        }

        public RippleBuilder ripplePersistent(boolean persistent) {
            this.ripplePersistent = persistent;
            return this;
        }

        public RippleBuilder rippleInAdapter(boolean inAdapter) {
            this.rippleSearchAdapter = inAdapter;
            return this;
        }

        public RippleBuilder rippleRoundedCornersDp(float radiusDp) {
            this.rippleRoundedCornerDp = radiusDp;
            return this;
        }

        public MaterialRippleLayout create() {
            MaterialRippleLayout layout = new MaterialRippleLayout(this.context);
            layout.setRippleColor(this.rippleColor);
            layout.setDefaultRippleAlphaInt((int)(255.0f * this.rippleAlphaFloat));
            layout.setRippleDelayClick(this.rippleDelayClick);
            layout.setRippleDiameterPx(Utils.dpToPx(this.context.getResources(), this.rippleDiameterDp));
            layout.setRippleDuration(this.rippleDuration);
            layout.setRippleFadeDuration(this.rippleFadeDuration);
            layout.setRippleHighlightColor(this.rippleHighlightColor);
            layout.setRipplePersistent(this.ripplePersistent);
            layout.setRippleOverlay(this.rippleOverlay);
            layout.setRippleInAdapter(this.rippleSearchAdapter);
            layout.setRippleRoundedCornersPx(Utils.dpToPx(this.context.getResources(), this.rippleRoundedCornerDp));
            ViewGroup.LayoutParams params = this.child.getLayoutParams();
            ViewGroup parent = (ViewGroup)this.child.getParent();
            int index = 0;
            if (parent != null && parent instanceof MaterialRippleLayout) {
                throw new IllegalStateException("MaterialRippleLayout could not be created: parent of the view already is a MaterialRippleLayout");
            }
            if (parent != null) {
                index = parent.indexOfChild(this.child);
                parent.removeView(this.child);
            }
            layout.addView(this.child, new ViewGroup.LayoutParams(-1, -1));
            if (parent != null) {
                parent.addView((View)layout, index, params);
            }
            return layout;
        }
    }

    private final class PressedEvent
    implements Runnable {
        private final MotionEvent event;

        public PressedEvent(MotionEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            MaterialRippleLayout.this.prepressed = false;
            MaterialRippleLayout.this.childView.setLongClickable(false);
            MaterialRippleLayout.this.childView.onTouchEvent(this.event);
            MaterialRippleLayout.this.childView.setPressed(true);
            MaterialRippleLayout.this.startHover();
        }
    }

    private class PerformClickEvent
    implements Runnable {
        private PerformClickEvent() {
        }

        @Override
        public void run() {
            if (MaterialRippleLayout.this.mHasPerformedLongPress) {
                return;
            }
            if (MaterialRippleLayout.this.getParent() instanceof AdapterView) {
                this.clickAdapterView((AdapterView)MaterialRippleLayout.this.getParent());
            } else if (MaterialRippleLayout.this.rippleInAdapter) {
                this.clickAdapterView(MaterialRippleLayout.this.findParentAdapterView());
            } else {
                MaterialRippleLayout.this.childView.performClick();
            }
        }

        private void clickAdapterView(AdapterView parent) {
            long itemId;
            int position = parent.getPositionForView((View)MaterialRippleLayout.this);
            long l = itemId = parent.getAdapter() != null ? parent.getAdapter().getItemId(position) : 0L;
            if (position != -1) {
                parent.performItemClick((View)MaterialRippleLayout.this, position, itemId);
            }
        }
    }
}

