/*
 * Decompiled with CFR 0.152.
 */
package io.karim;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.karim.MaterialRippleLayout;
import io.karim.materialtabs.R;
import java.util.Locale;

public class MaterialTabs
extends HorizontalScrollView {
    private static final String TAG = MaterialTabs.class.getSimpleName();
    private static final int[] ATTRS = new int[]{16842806, 16842901, 16842904, 16842965, 16842966, 16842968};
    private final PagerAdapterObserver adapterObserver = new PagerAdapterObserver();
    private static final int TEXT_COLOR_PRIMARY = 0;
    private static final int TEXT_SIZE_INDEX = 1;
    private static final int TEXT_COLOR_INDEX = 2;
    private static final int PADDING_INDEX = 3;
    private static final int PADDING_LEFT_INDEX = 4;
    private static final int PADDING_RIGHT_INDEX = 5;
    private final LinearLayout.LayoutParams defaultTabLayoutParams;
    private final LinearLayout.LayoutParams expandedTabLayoutParams;
    private final PageListener pageListener = new PageListener();
    private OnTabSelectedListener tabSelectedListener = null;
    private OnTabReselectedListener tabReselectedListener = null;
    public ViewPager.OnPageChangeListener delegatePageListener;
    private final LinearLayout tabsContainer;
    private ViewPager pager;
    private int tabCount;
    private int mSelectedTabPosition = -1;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private final Paint rectPaint;
    private int indicatorColor;
    private int indicatorHeight = 2;
    private int underlineHeight = 0;
    private int underlineColor;
    private int tabPadding = 12;
    private int tabTextSize = 14;
    private int tabTextColorUnselected;
    private int tabTextColorSelected;
    private int paddingLeft = 0;
    private int paddingRight = 0;
    private boolean sameWeightTabs = false;
    private boolean textAllCaps = true;
    private boolean isPaddingMiddle = false;
    private Typeface tabTypefaceUnselected = null;
    private Typeface tabTypefaceSelected = null;
    private int scrollOffset;
    private int lastScrollX = 0;
    private int rippleColor;
    private int rippleHighlightColor;
    private boolean rippleOverlay;
    private float rippleDiameterDp;
    private int rippleDuration;
    private float rippleAlphaFloat;
    private boolean rippleDelayClick;
    private int rippleFadeDuration;
    private boolean ripplePersistent;
    private boolean rippleInAdapter;
    private float rippleRoundedCornersDp;
    private Locale locale;
    private final ViewTreeObserver.OnGlobalLayoutListener firstTabGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            View view = MaterialTabs.this.tabsContainer.getChildAt(0);
            if (Build.VERSION.SDK_INT < 16) {
                MaterialTabs.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                MaterialTabs.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            if (MaterialTabs.this.isPaddingMiddle) {
                int mHalfWidthFirstTab = view.getWidth() / 2;
                MaterialTabs.this.paddingLeft = (MaterialTabs.this.paddingRight = MaterialTabs.this.getWidth() / 2 - mHalfWidthFirstTab);
            }
            MaterialTabs.this.setPadding(MaterialTabs.this.paddingLeft, MaterialTabs.this.getPaddingTop(), MaterialTabs.this.paddingRight, MaterialTabs.this.getPaddingBottom());
            if (MaterialTabs.this.scrollOffset == 0) {
                MaterialTabs.this.scrollOffset = MaterialTabs.this.getWidth() / 2 - MaterialTabs.this.paddingLeft;
            }
            MaterialTabs.this.currentPosition = MaterialTabs.this.pager.getCurrentItem();
            MaterialTabs.this.currentPositionOffset = 0.0f;
            MaterialTabs.this.scrollToChild(MaterialTabs.this.currentPosition, 0);
            MaterialTabs.this.selectTab(MaterialTabs.this.currentPosition);
        }
    };

    public MaterialTabs(Context context) {
        this(context, null);
    }

    public MaterialTabs(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialTabs(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabsContainer = new LinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabsContainer);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
        this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)dm);
        this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)dm);
        TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
        this.tabTextSize = a.getDimensionPixelSize(1, this.tabTextSize);
        int textPrimaryColor = a.getColor(0, 17170443);
        this.tabTextColorUnselected = a.getColor(2, textPrimaryColor);
        this.underlineColor = textPrimaryColor;
        this.indicatorColor = textPrimaryColor;
        int padding = a.getDimensionPixelSize(3, 0);
        this.paddingLeft = padding > 0 ? padding : a.getDimensionPixelSize(4, 0);
        this.paddingRight = padding > 0 ? padding : a.getDimensionPixelSize(5, 0);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.MaterialTabs);
        this.indicatorColor = a.getColor(R.styleable.MaterialTabs_mtIndicatorColor, this.indicatorColor);
        this.underlineColor = a.getColor(R.styleable.MaterialTabs_mtUnderlineColor, this.underlineColor);
        this.indicatorHeight = a.getDimensionPixelSize(R.styleable.MaterialTabs_mtIndicatorHeight, this.indicatorHeight);
        this.underlineHeight = a.getDimensionPixelSize(R.styleable.MaterialTabs_mtUnderlineHeight, this.underlineHeight);
        this.tabPadding = a.getDimensionPixelSize(R.styleable.MaterialTabs_mtTabPaddingLeftRight, this.tabPadding);
        this.sameWeightTabs = a.getBoolean(R.styleable.MaterialTabs_mtSameWeightTabs, this.sameWeightTabs);
        this.textAllCaps = a.getBoolean(R.styleable.MaterialTabs_mtTextAllCaps, this.textAllCaps);
        this.isPaddingMiddle = a.getBoolean(R.styleable.MaterialTabs_mtPaddingMiddle, this.isPaddingMiddle);
        this.tabTextColorSelected = a.getColor(R.styleable.MaterialTabs_mtTextColorSelected, textPrimaryColor);
        this.rippleColor = a.getColor(R.styleable.MaterialTabs_mtMrlRippleColor, -1);
        this.rippleHighlightColor = Color.argb((int)((int)((double)Color.alpha((int)this.rippleColor) * 0.25)), (int)Color.red((int)this.rippleColor), (int)Color.green((int)this.rippleColor), (int)Color.blue((int)this.rippleColor));
        this.rippleHighlightColor = a.getColor(R.styleable.MaterialTabs_mtMrlRippleHighlightColor, this.rippleHighlightColor);
        this.rippleDiameterDp = a.getDimension(R.styleable.MaterialTabs_mtMrlRippleDiameter, 20.0f);
        this.rippleOverlay = a.getBoolean(R.styleable.MaterialTabs_mtMrlRippleOverlay, false);
        this.rippleDuration = a.getInt(R.styleable.MaterialTabs_mtMrlRippleDuration, 250);
        this.rippleAlphaFloat = a.getFloat(R.styleable.MaterialTabs_mtMrlRippleAlpha, 0.2f);
        this.rippleDelayClick = a.getBoolean(R.styleable.MaterialTabs_mtMrlRippleDelayClick, false);
        this.rippleFadeDuration = a.getInteger(R.styleable.MaterialTabs_mtMrlRippleFadeDuration, 125);
        this.ripplePersistent = a.getBoolean(R.styleable.MaterialTabs_mtMrlRipplePersistent, false);
        this.rippleInAdapter = a.getBoolean(R.styleable.MaterialTabs_mtMrlRippleInAdapter, false);
        this.rippleRoundedCornersDp = a.getDimension(R.styleable.MaterialTabs_mtMrlRippleRoundedCorners, 0.0f);
        a.recycle();
        this.setMarginBottomTabContainer();
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.defaultTabLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.expandedTabLayoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
        if (this.locale == null) {
            this.locale = this.getResources().getConfiguration().locale;
        }
    }

    private void setMarginBottomTabContainer() {
        ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.tabsContainer.getLayoutParams();
        int bottomMargin = this.indicatorHeight >= this.underlineHeight ? this.indicatorHeight : this.underlineHeight;
        mlp.setMargins(mlp.leftMargin, mlp.topMargin, mlp.rightMargin, bottomMargin);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)mlp);
    }

    public void setViewPager(ViewPager pager) {
        this.pager = pager;
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
        pager.getAdapter().registerDataSetObserver((DataSetObserver)this.adapterObserver);
        this.adapterObserver.setAttached(true);
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.tabsContainer.removeAllViews();
        this.tabCount = this.pager.getAdapter().getCount();
        for (int i = 0; i < this.tabCount; ++i) {
            View tabView = this.pager.getAdapter() instanceof CustomTabProvider ? ((CustomTabProvider)this.pager.getAdapter()).getCustomTabView((ViewGroup)this, i) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.mt_tab, (ViewGroup)this, false);
            MaterialRippleLayout materialRippleLayout = MaterialRippleLayout.on(tabView).rippleAlpha(this.rippleAlphaFloat).rippleColor(this.rippleColor).rippleDelayClick(this.rippleDelayClick).rippleDiameterDp(this.rippleDiameterDp).rippleDuration(this.rippleDuration).rippleFadeDuration(this.rippleFadeDuration).rippleHighlightColor(this.rippleHighlightColor).rippleInAdapter(this.rippleInAdapter).rippleOverlay(this.rippleOverlay).ripplePersistent(this.ripplePersistent).rippleRoundedCornersDp(this.rippleRoundedCornersDp).create();
            CharSequence title = this.pager.getAdapter().getPageTitle(i);
            this.addTab(i, title, (View)materialRippleLayout);
        }
        this.updateTabStyles();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @SuppressLint(value={"NewApi"})
            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    MaterialTabs.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    MaterialTabs.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    private void addTab(final int position, CharSequence title, View tabView) {
        TextView textView = (TextView)tabView.findViewById(R.id.mt_tab_title);
        if (textView != null && title != null) {
            textView.setText(title);
        }
        tabView.setFocusable(true);
        tabView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MaterialTabs.this.tabSelectedListener != null) {
                    MaterialTabs.this.tabSelectedListener.onTabSelected(position);
                }
                if (MaterialTabs.this.pager.getCurrentItem() != position) {
                    MaterialTabs.this.markNotSelected(position);
                    MaterialTabs.this.pager.setCurrentItem(position);
                } else if (MaterialTabs.this.tabReselectedListener != null) {
                    MaterialTabs.this.tabReselectedListener.onTabReselected(position);
                }
            }
        });
        this.tabsContainer.addView(tabView, position, (ViewGroup.LayoutParams)(this.sameWeightTabs ? this.expandedTabLayoutParams : this.defaultTabLayoutParams));
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.tabCount; ++i) {
            View v = this.tabsContainer.getChildAt(i);
            v.setPadding(this.tabPadding, v.getPaddingTop(), this.tabPadding, v.getPaddingBottom());
            TextView tab_title = (TextView)v.findViewById(R.id.mt_tab_title);
            if (tab_title == null) continue;
            tab_title.setTextSize(0, (float)this.tabTextSize);
            tab_title.setTextColor(this.tabTextColorUnselected);
            tab_title.setTypeface(this.tabTypefaceUnselected);
            if (!this.textAllCaps) continue;
            if (Build.VERSION.SDK_INT >= 14) {
                tab_title.setAllCaps(true);
                continue;
            }
            tab_title.setText((CharSequence)tab_title.getText().toString().toUpperCase(this.locale));
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = this.tabsContainer.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.scrollOffset;
            Pair<Float, Float> lines = this.getIndicatorCoordinates();
            newScrollX = (int)((float)newScrollX + (((Float)lines.second).floatValue() - ((Float)lines.first).floatValue()) / 2.0f);
        }
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    private Pair<Float, Float> getIndicatorCoordinates() {
        View currentTab = this.tabsContainer.getChildAt(this.currentPosition);
        float lineLeft = currentTab.getLeft();
        float lineRight = currentTab.getRight();
        if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
            View nextTab = this.tabsContainer.getChildAt(this.currentPosition + 1);
            float nextTabLeft = nextTab.getLeft();
            float nextTabRight = nextTab.getRight();
            lineLeft = this.currentPositionOffset * nextTabLeft + (1.0f - this.currentPositionOffset) * lineLeft;
            lineRight = this.currentPositionOffset * nextTabRight + (1.0f - this.currentPositionOffset) * lineRight;
        }
        return new Pair((Object)Float.valueOf(lineLeft), (Object)Float.valueOf(lineRight));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.isPaddingMiddle || this.paddingLeft > 0 || this.paddingRight > 0) {
            this.tabsContainer.setMinimumWidth(this.getWidth());
            this.setClipToPadding(false);
        }
        if (this.tabsContainer.getChildCount() > 0) {
            this.tabsContainer.getChildAt(0).getViewTreeObserver().addOnGlobalLayoutListener(this.firstTabGlobalLayoutListener);
        }
        super.onLayout(changed, l, t, r, b);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.tabCount == 0) {
            return;
        }
        int height = this.getHeight();
        this.rectPaint.setColor(this.indicatorColor);
        Pair<Float, Float> lines = this.getIndicatorCoordinates();
        canvas.drawRect(((Float)lines.first).floatValue() + (float)this.paddingLeft, (float)(height - this.indicatorHeight), ((Float)lines.second).floatValue() + (float)this.paddingLeft, (float)height, this.rectPaint);
        this.rectPaint.setColor(this.underlineColor);
        canvas.drawRect((float)this.paddingLeft, (float)(height - this.underlineHeight), (float)(this.tabsContainer.getWidth() + this.paddingRight), (float)height, this.rectPaint);
    }

    public void setOnTabReselectedListener(OnTabReselectedListener tabReselectedListener) {
        this.tabReselectedListener = tabReselectedListener;
    }

    public void setOnTabSelectedListener(OnTabSelectedListener tabSelectedListener) {
        this.tabSelectedListener = tabSelectedListener;
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.delegatePageListener = listener;
    }

    private void selectTab(int currentItem) {
        this.markSelected(currentItem);
        for (int i = 0; i < this.tabCount; ++i) {
            if (i == currentItem) continue;
            this.markNotSelected(i);
        }
        this.mSelectedTabPosition = currentItem;
    }

    private void updateSelection(int position) {
        this.selectTab(position);
    }

    private void markNotSelected(int position) {
        View tab = this.tabsContainer.getChildAt(position);
        if (tab != null) {
            TextView title = (TextView)tab.findViewById(R.id.mt_tab_title);
            if (title != null) {
                if (this.tabTypefaceUnselected != null) {
                    title.setTypeface(this.tabTypefaceUnselected);
                } else {
                    title.setTypeface(Typeface.DEFAULT);
                }
                title.setTextColor(this.tabTextColorUnselected);
            } else if (this.pager.getAdapter() instanceof CustomTabProvider) {
                if (tab instanceof MaterialRippleLayout) {
                    View child = ((MaterialRippleLayout)tab).getChildAt(0);
                    ((CustomTabProvider)this.pager.getAdapter()).onCustomTabViewUnselected(child, position, !this.isTabSelected(position));
                } else {
                    ((CustomTabProvider)this.pager.getAdapter()).onCustomTabViewUnselected(tab, position, !this.isTabSelected(position));
                }
            }
        }
    }

    private void markSelected(int position) {
        View tab = this.tabsContainer.getChildAt(position);
        if (tab != null) {
            TextView title = (TextView)tab.findViewById(R.id.mt_tab_title);
            if (title != null) {
                if (this.tabTypefaceSelected != null) {
                    title.setTypeface(this.tabTypefaceSelected);
                } else {
                    title.setTypeface(Typeface.DEFAULT_BOLD);
                }
                title.setTextColor(this.tabTextColorSelected);
            } else if (this.pager.getAdapter() instanceof CustomTabProvider) {
                if (tab instanceof MaterialRippleLayout) {
                    View child = ((MaterialRippleLayout)tab).getChildAt(0);
                    ((CustomTabProvider)this.pager.getAdapter()).onCustomTabViewSelected(child, position, this.isTabSelected(position));
                } else {
                    ((CustomTabProvider)this.pager.getAdapter()).onCustomTabViewSelected(tab, position, this.isTabSelected(position));
                }
            }
        }
    }

    private boolean isTabSelected(int position) {
        return position == this.mSelectedTabPosition;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.pager != null && !this.adapterObserver.isAttached()) {
            this.pager.getAdapter().registerDataSetObserver((DataSetObserver)this.adapterObserver);
            this.adapterObserver.setAttached(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.pager != null && this.adapterObserver.isAttached()) {
            this.pager.getAdapter().unregisterDataSetObserver((DataSetObserver)this.adapterObserver);
            this.adapterObserver.setAttached(false);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPosition = savedState.currentPosition;
        if (this.currentPosition != 0 && this.tabsContainer.getChildCount() > 0) {
            this.markNotSelected(0);
            this.markSelected(this.currentPosition);
        }
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPosition = this.currentPosition;
        return savedState;
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public boolean getSameWeightTabs() {
        return this.sameWeightTabs;
    }

    public int getTextSize() {
        return this.tabTextSize;
    }

    public boolean isTextAllCaps() {
        return this.textAllCaps;
    }

    public int getTextColor() {
        return this.tabTextColorUnselected;
    }

    public int getTabPaddingLeftRight() {
        return this.tabPadding;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public void setIndicatorColorResource(int resId) {
        this.indicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.indicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.underlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.underlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public void setSameWeightTabs(boolean sameWeightTabs) {
        this.sameWeightTabs = sameWeightTabs;
        if (this.pager != null) {
            this.requestLayout();
        }
    }

    public void setPaddingMiddle(boolean isPaddingMiddle) {
        this.isPaddingMiddle = isPaddingMiddle;
        if (this.pager != null) {
            this.requestLayout();
        }
    }

    public void setAllCaps(boolean textAllCaps) {
        this.textAllCaps = textAllCaps;
    }

    public void setTextSize(int textSizePx) {
        this.tabTextSize = textSizePx;
        this.updateTabStyles();
    }

    public void setTextColorUnselected(int textColor) {
        this.tabTextColorUnselected = textColor;
        this.updateTabStyles();
    }

    public void setTextColorResource(int resId) {
        this.setTextColorUnselected(this.getResources().getColor(resId));
    }

    public void setTextColorSelected(int textColorSelected) {
        this.tabTextColorSelected = textColorSelected;
        this.invalidate();
    }

    public void setTextColorSelectedResource(int resId) {
        this.setTextColorSelected(this.getResources().getColor(resId));
    }

    public void setTypefaceSelected(Typeface typeface) {
        this.tabTypefaceSelected = typeface;
        this.updateTabStyles();
    }

    public void setTypefaceUnselected(Typeface typeface) {
        this.tabTypefaceUnselected = typeface;
        this.updateTabStyles();
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.tabPadding = paddingPx;
        this.updateTabStyles();
    }

    public void setRippleColor(int rippleColor) {
        this.rippleColor = rippleColor;
        this.notifyDataSetChanged();
    }

    public void setRippleHighlightColor(int rippleHighlightColor) {
        this.rippleHighlightColor = rippleHighlightColor;
        this.notifyDataSetChanged();
    }

    public void setRippleOverlay(boolean rippleOverlay) {
        this.rippleOverlay = rippleOverlay;
        this.notifyDataSetChanged();
    }

    public void setRippleDiameterDp(float rippleDiameterDp) {
        this.rippleDiameterDp = rippleDiameterDp;
        this.notifyDataSetChanged();
    }

    public void setRippleDuration(int rippleDuration) {
        this.rippleDuration = rippleDuration;
        this.notifyDataSetChanged();
    }

    public void setRippleAlphaFloat(float rippleAlphaFloat) {
        this.rippleAlphaFloat = rippleAlphaFloat;
        this.notifyDataSetChanged();
    }

    public void setRippleDelayClick(boolean rippleDelayClick) {
        this.rippleDelayClick = rippleDelayClick;
        this.notifyDataSetChanged();
    }

    public void setRippleFadeDuration(int rippleFadeDuration) {
        this.rippleFadeDuration = rippleFadeDuration;
        this.notifyDataSetChanged();
    }

    public void setRipplePersistent(boolean ripplePersistent) {
        this.ripplePersistent = ripplePersistent;
        this.notifyDataSetChanged();
    }

    public void setRippleInAdapter(boolean rippleInAdapter) {
        this.rippleInAdapter = rippleInAdapter;
        this.notifyDataSetChanged();
    }

    public void setRippleRoundedCornersDp(float rippleRoundedCornersDp) {
        this.rippleRoundedCornersDp = rippleRoundedCornersDp;
        this.notifyDataSetChanged();
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPosition = in.readInt();
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPosition);
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private boolean attached = false;

        private PagerAdapterObserver() {
        }

        public void onChanged() {
            MaterialTabs.this.notifyDataSetChanged();
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public boolean isAttached() {
            return this.attached;
        }
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            MaterialTabs.this.currentPosition = position;
            MaterialTabs.this.currentPositionOffset = positionOffset;
            int offset = MaterialTabs.this.tabCount > 0 ? (int)(positionOffset * (float)MaterialTabs.this.tabsContainer.getChildAt(position).getWidth()) : 0;
            MaterialTabs.this.scrollToChild(position, offset);
            MaterialTabs.this.invalidate();
            if (MaterialTabs.this.delegatePageListener != null) {
                MaterialTabs.this.delegatePageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 0) {
                MaterialTabs.this.scrollToChild(MaterialTabs.this.pager.getCurrentItem(), 0);
            }
            MaterialTabs.this.selectTab(MaterialTabs.this.pager.getCurrentItem());
            if (MaterialTabs.this.delegatePageListener != null) {
                MaterialTabs.this.delegatePageListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            MaterialTabs.this.updateSelection(position);
            if (MaterialTabs.this.delegatePageListener != null) {
                MaterialTabs.this.delegatePageListener.onPageSelected(position);
            }
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1);
    }

    public static interface OnTabReselectedListener {
        public void onTabReselected(int var1);
    }

    public static interface CustomTabProvider {
        public View getCustomTabView(ViewGroup var1, int var2);

        public void onCustomTabViewSelected(View var1, int var2, boolean var3);

        public void onCustomTabViewUnselected(View var1, int var2, boolean var3);
    }
}

