/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.katharsis.core.internal.boot.DefaultServiceDiscoveryFactory;
import io.katharsis.core.internal.boot.FallbackServiceDiscoveryFactory;
import io.katharsis.core.internal.boot.PropertiesProvider;
import io.katharsis.core.internal.dispatcher.ControllerRegistry;
import io.katharsis.core.internal.dispatcher.ControllerRegistryBuilder;
import io.katharsis.core.internal.dispatcher.RequestDispatcher;
import io.katharsis.core.internal.exception.ExceptionMapperLookup;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.core.internal.exception.ExceptionMapperRegistryBuilder;
import io.katharsis.core.internal.jackson.JsonApiModuleBuilder;
import io.katharsis.core.internal.query.QueryAdapterBuilder;
import io.katharsis.core.internal.query.QuerySpecAdapterBuilder;
import io.katharsis.core.internal.registry.ResourceRegistryImpl;
import io.katharsis.core.internal.repository.information.DefaultRelationshipRepositoryInformationBuilder;
import io.katharsis.core.internal.repository.information.DefaultResourceRepositoryInformationBuilder;
import io.katharsis.core.internal.resource.AnnotationResourceInformationBuilder;
import io.katharsis.core.internal.resource.DocumentMapper;
import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.errorhandling.mapper.JsonApiExceptionMapper;
import io.katharsis.legacy.internal.QueryParamsAdapterBuilder;
import io.katharsis.legacy.locator.JsonServiceLocator;
import io.katharsis.legacy.locator.SampleJsonServiceLocator;
import io.katharsis.legacy.queryParams.QueryParamsBuilder;
import io.katharsis.legacy.repository.RelationshipRepository;
import io.katharsis.legacy.repository.ResourceRepository;
import io.katharsis.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.katharsis.legacy.repository.annotations.JsonApiResourceRepository;
import io.katharsis.module.Module;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.module.ServiceDiscovery;
import io.katharsis.module.ServiceDiscoveryFactory;
import io.katharsis.module.SimpleModule;
import io.katharsis.queryspec.DefaultQuerySpecDeserializer;
import io.katharsis.queryspec.QuerySpecDeserializer;
import io.katharsis.repository.RelationshipRepositoryV2;
import io.katharsis.repository.Repository;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.repository.filter.DocumentFilter;
import io.katharsis.resource.information.ResourceFieldNameTransformer;
import io.katharsis.resource.registry.ConstantServiceUrlProvider;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import java.lang.annotation.Annotation;
import java.util.List;
import net.jodah.typetools.TypeResolver;

public class KatharsisBoot {
    private final ModuleRegistry moduleRegistry = new ModuleRegistry();
    private ObjectMapper objectMapper;
    private QueryParamsBuilder queryParamsBuilder;
    private QuerySpecDeserializer querySpecDeserializer = new DefaultQuerySpecDeserializer();
    private ServiceUrlProvider serviceUrlProvider;
    private boolean configured;
    private JsonServiceLocator serviceLocator = new SampleJsonServiceLocator();
    private ResourceRegistry resourceRegistry;
    private RequestDispatcher requestDispatcher;
    private PropertiesProvider propertiesProvider;
    private ResourceFieldNameTransformer resourceFieldNameTransformer;
    private ServiceUrlProvider defaultServiceUrlProvider;
    private ServiceDiscoveryFactory serviceDiscoveryFactory = new DefaultServiceDiscoveryFactory();
    private ServiceDiscovery serviceDiscovery;
    private ExceptionMapperRegistry exceptionMapperRegistry;
    private DocumentMapper documentMapper;

    public void setObjectMapper(ObjectMapper objectMapper) {
        PreconditionUtil.assertNull("ObjectMapper already set", this.objectMapper);
        this.objectMapper = objectMapper;
    }

    public void setServiceDiscoveryFactory(ServiceDiscoveryFactory factory) {
        this.serviceDiscoveryFactory = factory;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
        this.moduleRegistry.setServiceDiscovery(serviceDiscovery);
    }

    public void setQueryParamsBuilds(QueryParamsBuilder queryParamsBuilder) {
        PreconditionUtil.assertNotNull("A query params builder must be provided, but is null", queryParamsBuilder);
        this.queryParamsBuilder = queryParamsBuilder;
        this.querySpecDeserializer = null;
    }

    public void setQuerySpecDeserializer(QuerySpecDeserializer querySpecDeserializer) {
        PreconditionUtil.assertNotNull("A query spec deserializer must be provided, but is null", querySpecDeserializer);
        this.querySpecDeserializer = querySpecDeserializer;
        this.queryParamsBuilder = null;
    }

    public void setServiceLocator(JsonServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public void addModule(Module module) {
        this.moduleRegistry.addModule(module);
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.checkNotConfiguredYet();
        this.serviceUrlProvider = serviceUrlProvider;
    }

    private void checkNotConfiguredYet() {
        if (this.configured) {
            throw new IllegalStateException("cannot further modify KatharsisFeature once configured/initialized by JAX-RS");
        }
    }

    public void boot() {
        this.configured = true;
        this.setupServiceUrlProvider();
        this.setupServiceDiscovery();
        this.bootDiscovery();
    }

    private void setupServiceDiscovery() {
        if (this.serviceDiscovery == null) {
            FallbackServiceDiscoveryFactory fallback = new FallbackServiceDiscoveryFactory(this.serviceDiscoveryFactory, this.serviceLocator, this.propertiesProvider);
            this.setServiceDiscovery(fallback.getInstance());
        }
    }

    private void bootDiscovery() {
        this.setupObjectMapper();
        this.addModules();
        this.setupComponents();
        this.resourceRegistry = new ResourceRegistryImpl(this.moduleRegistry, this.serviceUrlProvider);
        this.moduleRegistry.init(this.objectMapper);
        JsonApiModuleBuilder jsonApiModuleBuilder = new JsonApiModuleBuilder();
        this.objectMapper.registerModule((com.fasterxml.jackson.databind.Module)jsonApiModuleBuilder.build(this.resourceRegistry, false));
        this.exceptionMapperRegistry = this.buildExceptionMapperRegistry();
        this.requestDispatcher = this.createRequestDispatcher(this.exceptionMapperRegistry);
    }

    private void setupObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.findAndRegisterModules();
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.exceptionMapperRegistry;
    }

    private RequestDispatcher createRequestDispatcher(ExceptionMapperRegistry exceptionMapperRegistry) {
        ControllerRegistryBuilder controllerRegistryBuilder = new ControllerRegistryBuilder(this.resourceRegistry, this.moduleRegistry.getTypeParser(), this.objectMapper, this.propertiesProvider);
        ControllerRegistry controllerRegistry = controllerRegistryBuilder.build();
        this.documentMapper = controllerRegistryBuilder.getDocumentMapper();
        QueryAdapterBuilder queryAdapterBuilder = this.queryParamsBuilder != null ? new QueryParamsAdapterBuilder(this.queryParamsBuilder, this.resourceRegistry) : new QuerySpecAdapterBuilder(this.querySpecDeserializer, this.moduleRegistry);
        return new RequestDispatcher(this.moduleRegistry, controllerRegistry, exceptionMapperRegistry, queryAdapterBuilder);
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    private ExceptionMapperRegistry buildExceptionMapperRegistry() {
        ExceptionMapperLookup exceptionMapperLookup = this.moduleRegistry.getExceptionMapperLookup();
        ExceptionMapperRegistryBuilder mapperRegistryBuilder = new ExceptionMapperRegistryBuilder();
        return mapperRegistryBuilder.build(exceptionMapperLookup);
    }

    private void setupComponents() {
        Annotation annotation;
        if (this.resourceFieldNameTransformer == null) {
            this.resourceFieldNameTransformer = new ResourceFieldNameTransformer(this.objectMapper.getSerializationConfig());
        }
        SimpleModule module = new SimpleModule("discovery");
        module.addRepositoryInformationBuilder(new DefaultResourceRepositoryInformationBuilder());
        module.addRepositoryInformationBuilder(new DefaultRelationshipRepositoryInformationBuilder());
        module.addResourceInformationBuilder(new AnnotationResourceInformationBuilder(this.resourceFieldNameTransformer));
        for (JsonApiExceptionMapper jsonApiExceptionMapper : this.serviceDiscovery.getInstancesByType(JsonApiExceptionMapper.class)) {
            module.addExceptionMapper(jsonApiExceptionMapper);
        }
        for (DocumentFilter documentFilter : this.serviceDiscovery.getInstancesByType(DocumentFilter.class)) {
            module.addFilter(documentFilter);
        }
        for (Object object : this.serviceDiscovery.getInstancesByType(Repository.class)) {
            this.setupRepository(module, object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiResourceRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiResourceRepository.class).get();
            Class<?> resourceClass = annotation.value();
            module.addRepository(resourceClass, object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiRelationshipRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiRelationshipRepository.class).get();
            module.addRepository(annotation.source(), annotation.target(), object);
        }
        this.moduleRegistry.addModule(module);
    }

    private void setupRepository(SimpleModule module, Object repository) {
        if (repository instanceof ResourceRepository) {
            ResourceRepository resRepository = (ResourceRepository)repository;
            Class[] typeArgs = TypeResolver.resolveRawArguments(ResourceRepository.class, resRepository.getClass());
            Class resourceClass = typeArgs[0];
            module.addRepository(resourceClass, resRepository);
        } else if (repository instanceof RelationshipRepository) {
            RelationshipRepository relRepository = (RelationshipRepository)repository;
            Class[] typeArgs = TypeResolver.resolveRawArguments(RelationshipRepository.class, relRepository.getClass());
            Class sourceResourceClass = typeArgs[0];
            Class targetResourceClass = typeArgs[2];
            module.addRepository(sourceResourceClass, targetResourceClass, relRepository);
        } else if (repository instanceof ResourceRepositoryV2) {
            ResourceRepositoryV2 resRepository = (ResourceRepositoryV2)repository;
            module.addRepository(resRepository.getResourceClass(), resRepository);
        } else if (repository instanceof RelationshipRepositoryV2) {
            RelationshipRepositoryV2 relRepository = (RelationshipRepositoryV2)repository;
            module.addRepository(relRepository.getSourceResourceClass(), relRepository.getTargetResourceClass(), relRepository);
        } else {
            throw new IllegalStateException(repository.toString());
        }
    }

    private void addModules() {
        ServiceDiscovery serviceDiscovery = this.moduleRegistry.getServiceDiscovery();
        List<Module> modules = serviceDiscovery.getInstancesByType(Module.class);
        for (Module module : modules) {
            this.moduleRegistry.addModule(module);
        }
    }

    private void setupServiceUrlProvider() {
        if (this.serviceUrlProvider == null) {
            String resourceDefaultDomain = this.getProperty("katharsis.config.core.resource.domain");
            String webPathPrefix = this.getWebPathPrefix();
            if (resourceDefaultDomain != null) {
                String serviceUrl = KatharsisBoot.buildServiceUrl(resourceDefaultDomain, webPathPrefix);
                this.serviceUrlProvider = new ConstantServiceUrlProvider(serviceUrl);
            } else {
                this.serviceUrlProvider = this.defaultServiceUrlProvider;
            }
        }
        PreconditionUtil.assertNotNull("expected serviceUrlProvider", this.serviceUrlProvider);
    }

    private String getProperty(String key) {
        if (this.propertiesProvider != null) {
            return this.propertiesProvider.getProperty(key);
        }
        return null;
    }

    private static String buildServiceUrl(String resourceDefaultDomain, String webPathPrefix) {
        return resourceDefaultDomain + (webPathPrefix != null ? webPathPrefix : "");
    }

    public RequestDispatcher getRequestDispatcher() {
        PreconditionUtil.assertNotNull("expected requestDispatcher", this.requestDispatcher);
        return this.requestDispatcher;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public void setResourceFieldNameTransformer(ResourceFieldNameTransformer resourceFieldNameTransformer) {
        this.resourceFieldNameTransformer = resourceFieldNameTransformer;
    }

    public void setDefaultServiceUrlProvider(ServiceUrlProvider defaultServiceUrlProvider) {
        this.defaultServiceUrlProvider = defaultServiceUrlProvider;
    }

    public String getWebPathPrefix() {
        return this.getProperty("katharsis.config.web.path.prefix");
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.moduleRegistry.getServiceDiscovery();
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        PreconditionUtil.assertNotNull("Setting the default page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.querySpecDeserializer);
        ((DefaultQuerySpecDeserializer)this.querySpecDeserializer).setDefaultLimit(defaultPageLimit);
    }

    public void setMaxPageLimit(Long maxPageLimit) {
        PreconditionUtil.assertNotNull("Setting the max page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.querySpecDeserializer);
        ((DefaultQuerySpecDeserializer)this.querySpecDeserializer).setMaxPageLimit(maxPageLimit);
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    public QuerySpecDeserializer getQuerySpecDeserializer() {
        return this.querySpecDeserializer;
    }
}

