/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.dispatcher.ControllerLookup;
import io.katharsis.core.internal.dispatcher.controller.BaseController;
import io.katharsis.core.internal.dispatcher.controller.CollectionGet;
import io.katharsis.core.internal.dispatcher.controller.FieldResourceGet;
import io.katharsis.core.internal.dispatcher.controller.FieldResourcePost;
import io.katharsis.core.internal.dispatcher.controller.RelationshipsResourceDelete;
import io.katharsis.core.internal.dispatcher.controller.RelationshipsResourceGet;
import io.katharsis.core.internal.dispatcher.controller.RelationshipsResourcePatch;
import io.katharsis.core.internal.dispatcher.controller.RelationshipsResourcePost;
import io.katharsis.core.internal.dispatcher.controller.ResourceDelete;
import io.katharsis.core.internal.dispatcher.controller.ResourceGet;
import io.katharsis.core.internal.dispatcher.controller.ResourcePatch;
import io.katharsis.core.internal.dispatcher.controller.ResourcePost;
import io.katharsis.core.internal.resource.DocumentMapper;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.parser.TypeParser;
import java.util.HashSet;
import java.util.Set;

public class DefaultControllerLookup
implements ControllerLookup {
    private ResourceRegistry resourceRegistry;
    private TypeParser typeParser;
    private ObjectMapper objectMapper;
    private DocumentMapper documentMapper;

    public DefaultControllerLookup(ResourceRegistry resourceRegistry, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper) {
        this.resourceRegistry = resourceRegistry;
        this.typeParser = typeParser;
        this.objectMapper = objectMapper;
        this.documentMapper = documentMapper;
    }

    @Override
    public Set<BaseController> getControllers() {
        HashSet<BaseController> controllers = new HashSet<BaseController>();
        controllers.add(new RelationshipsResourceDelete(this.resourceRegistry, this.typeParser));
        controllers.add(new RelationshipsResourcePatch(this.resourceRegistry, this.typeParser));
        controllers.add(new RelationshipsResourcePost(this.resourceRegistry, this.typeParser));
        controllers.add(new ResourceDelete(this.resourceRegistry, this.typeParser));
        controllers.add(new CollectionGet(this.resourceRegistry, this.objectMapper, this.typeParser, this.documentMapper));
        controllers.add(new FieldResourceGet(this.resourceRegistry, this.objectMapper, this.typeParser, this.documentMapper));
        controllers.add(new RelationshipsResourceGet(this.resourceRegistry, this.objectMapper, this.typeParser, this.documentMapper));
        controllers.add(new ResourceGet(this.resourceRegistry, this.objectMapper, this.typeParser, this.documentMapper));
        controllers.add(new FieldResourcePost(this.resourceRegistry, this.typeParser, this.objectMapper, this.documentMapper));
        controllers.add(new ResourcePatch(this.resourceRegistry, this.typeParser, this.objectMapper, this.documentMapper));
        controllers.add(new ResourcePost(this.resourceRegistry, this.typeParser, this.objectMapper, this.documentMapper));
        return controllers;
    }
}

