/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher;

import io.katharsis.core.internal.dispatcher.ControllerRegistry;
import io.katharsis.core.internal.dispatcher.controller.BaseController;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.core.internal.query.QueryAdapterBuilder;
import io.katharsis.errorhandling.exception.RepositoryNotFoundException;
import io.katharsis.errorhandling.exception.ResourceFieldNotFoundException;
import io.katharsis.errorhandling.mapper.JsonApiExceptionMapper;
import io.katharsis.legacy.internal.QueryParamsAdapter;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.legacy.queryParams.QueryParams;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.repository.filter.DocumentFilter;
import io.katharsis.repository.filter.DocumentFilterChain;
import io.katharsis.repository.filter.DocumentFilterContext;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.Optional;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ControllerRegistry controllerRegistry;
    private final ExceptionMapperRegistry exceptionMapperRegistry;
    private ModuleRegistry moduleRegistry;
    private QueryAdapterBuilder queryAdapterBuilder;

    public RequestDispatcher(ModuleRegistry moduleRegistry, ControllerRegistry controllerRegistry, ExceptionMapperRegistry exceptionMapperRegistry, QueryAdapterBuilder queryAdapterBuilder) {
        this.controllerRegistry = controllerRegistry;
        this.moduleRegistry = moduleRegistry;
        this.exceptionMapperRegistry = exceptionMapperRegistry;
        this.queryAdapterBuilder = queryAdapterBuilder;
    }

    public Response dispatchRequest(JsonPath jsonPath, String method, Map<String, Set<String>> parameters, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        try {
            BaseController controller = this.controllerRegistry.getController(jsonPath, method);
            ResourceInformation resourceInformation = this.getRequestedResource(jsonPath);
            QueryAdapter queryAdapter = this.queryAdapterBuilder.build(resourceInformation, parameters);
            DefaultFilterRequestContext context = new DefaultFilterRequestContext(jsonPath, queryAdapter, parameterProvider, requestBody, method);
            DefaultFilterChain chain = new DefaultFilterChain(controller);
            return chain.doFilter(context);
        }
        catch (Exception e) {
            Optional<JsonApiExceptionMapper> exceptionMapper = this.exceptionMapperRegistry.findMapperFor(e.getClass());
            if (exceptionMapper.isPresent()) {
                return exceptionMapper.get().toErrorResponse(e).toResponse();
            }
            this.logger.error("failed to process request", (Throwable)e);
            throw e;
        }
    }

    private ResourceInformation getRequestedResource(JsonPath jsonPath) {
        ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntry(jsonPath.getResourceName());
        if (registryEntry == null) {
            throw new RepositoryNotFoundException(jsonPath.getResourceName());
        }
        String elementName = jsonPath.getElementName();
        if (elementName != null && !elementName.equals(jsonPath.getResourceName())) {
            ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(elementName);
            if (relationshipField == null) {
                throw new ResourceFieldNotFoundException(elementName);
            }
            String oppositeResourceType = relationshipField.getOppositeResourceType();
            return resourceRegistry.getEntry(oppositeResourceType).getResourceInformation();
        }
        return registryEntry.getResourceInformation();
    }

    public void dispatchAction(JsonPath jsonPath, String method, Map<String, Set<String>> parameters) {
        ActionFilterChain chain = new ActionFilterChain();
        DefaultFilterRequestContext context = new DefaultFilterRequestContext(jsonPath, null, null, null, method);
        chain.doFilter(context);
    }

    public QueryAdapterBuilder getQueryAdapterBuilder() {
        return this.queryAdapterBuilder;
    }

    class DefaultFilterRequestContext
    implements DocumentFilterContext {
        protected JsonPath jsonPath;
        protected QueryAdapter queryAdapter;
        protected RepositoryMethodParameterProvider parameterProvider;
        protected Document requestBody;
        private String method;

        public DefaultFilterRequestContext(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody, String method) {
            this.jsonPath = jsonPath;
            this.queryAdapter = queryAdapter;
            this.parameterProvider = parameterProvider;
            this.requestBody = requestBody;
            this.method = method;
        }

        @Override
        public Document getRequestBody() {
            return this.requestBody;
        }

        @Override
        public RepositoryMethodParameterProvider getParameterProvider() {
            return this.parameterProvider;
        }

        @Override
        public QueryParams getQueryParams() {
            return ((QueryParamsAdapter)this.queryAdapter).getQueryParams();
        }

        @Override
        public QueryAdapter getQueryAdapter() {
            return this.queryAdapter;
        }

        @Override
        public JsonPath getJsonPath() {
            return this.jsonPath;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }

    class ActionFilterChain
    implements DocumentFilterChain {
        protected int filterIndex = 0;

        ActionFilterChain() {
        }

        @Override
        public Response doFilter(DocumentFilterContext context) {
            List<DocumentFilter> filters = RequestDispatcher.this.moduleRegistry.getFilters();
            if (this.filterIndex == filters.size()) {
                return null;
            }
            DocumentFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filter(context, this);
        }
    }

    class DefaultFilterChain
    implements DocumentFilterChain {
        protected int filterIndex = 0;
        protected BaseController controller;

        public DefaultFilterChain(BaseController controller) {
            this.controller = controller;
        }

        @Override
        public Response doFilter(DocumentFilterContext context) {
            List<DocumentFilter> filters = RequestDispatcher.this.moduleRegistry.getFilters();
            if (this.filterIndex == filters.size()) {
                return this.controller.handle(context.getJsonPath(), context.getQueryAdapter(), context.getParameterProvider(), context.getRequestBody());
            }
            DocumentFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filter(context, this);
        }
    }
}

