/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.dispatcher.controller.ResourceIncludeField;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.dispatcher.path.ResourcePath;
import io.katharsis.core.internal.repository.adapter.ResourceRepositoryAdapter;
import io.katharsis.core.internal.resource.DocumentMapper;
import io.katharsis.errorhandling.exception.ResourceNotFoundException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.parser.TypeParser;

public class CollectionGet
extends ResourceIncludeField {
    public CollectionGet(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, TypeParser typeParser, DocumentMapper documentMapper) {
        super(resourceRegistry, objectMapper, typeParser, documentMapper);
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String requestType) {
        return jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.GET.name().equals(requestType);
    }

    @Override
    public Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        JsonApiResponse entities;
        String resourceName = jsonPath.getElementName();
        RegistryEntry registryEntry = this.resourceRegistry.getEntry(resourceName);
        if (registryEntry == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        if (jsonPath.getIds() == null || jsonPath.getIds().getIds().isEmpty()) {
            entities = resourceRepository.findAll(queryAdapter);
        } else {
            Class<?> idType = registryEntry.getResourceInformation().getIdField().getType();
            Iterable<?> parsedIds = this.typeParser.parse(jsonPath.getIds().getIds(), idType);
            entities = resourceRepository.findAll(parsedIds, queryAdapter);
        }
        Document responseDocument = this.documentMapper.toDocument(entities, queryAdapter, parameterProvider);
        return new Response(responseDocument, 200);
    }
}

