/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.repository.adapter;

import io.katharsis.core.internal.repository.adapter.RepositoryRequestSpecImpl;
import io.katharsis.core.internal.repository.adapter.ResponseRepositoryAdapter;
import io.katharsis.legacy.internal.AnnotatedResourceRepositoryAdapter;
import io.katharsis.legacy.repository.ResourceRepository;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.repository.filter.RepositoryFilterContext;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.request.RepositoryRequestSpec;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.resource.information.ResourceInformation;
import java.io.Serializable;

public class ResourceRepositoryAdapter<T, I extends Serializable>
extends ResponseRepositoryAdapter {
    private final Object resourceRepository;
    private final boolean isAnnotated;

    public ResourceRepositoryAdapter(ResourceInformation resourceInformation, ModuleRegistry moduleRegistry, Object resourceRepository) {
        super(resourceInformation, moduleRegistry);
        this.resourceRepository = resourceRepository;
        this.isAnnotated = resourceRepository instanceof AnnotatedResourceRepositoryAdapter;
    }

    public JsonApiResponse findOne(I id, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Serializable id = request.getId();
                Object resource = ResourceRepositoryAdapter.this.isAnnotated ? ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).findOne(id, queryAdapter) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).findOne(id, request.getQuerySpec(ResourceRepositoryAdapter.this.resourceInformation)) : ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).findOne(id, request.getQueryParams()));
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindId(this.moduleRegistry, queryAdapter, id);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findAll(QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Iterable resources;
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (ResourceRepositoryAdapter.this.isAnnotated) {
                    resources = ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).findAll(queryAdapter);
                } else if (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2) {
                    QuerySpec querySpec = request.getQuerySpec(ResourceRepositoryAdapter.this.resourceInformation);
                    resources = ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).findAll(querySpec);
                } else {
                    resources = ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).findAll(request.getQueryParams());
                }
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindAll(this.moduleRegistry, queryAdapter);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findAll(Iterable ids, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Iterable ids = request.getIds();
                Iterable resources = ResourceRepositoryAdapter.this.isAnnotated ? ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).findAll(ids, queryAdapter) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).findAll(ids, request.getQuerySpec(ResourceRepositoryAdapter.this.resourceInformation)) : ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).findAll(ids, request.getQueryParams()));
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindIds(this.moduleRegistry, queryAdapter, ids);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public <S extends T> JsonApiResponse update(S entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.PATCH);
    }

    public <S extends T> JsonApiResponse create(S entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.POST);
    }

    private <S extends T> JsonApiResponse save(S entity, QueryAdapter queryAdapter, final HttpMethod method) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object entity = request.getEntity();
                Object resource = ResourceRepositoryAdapter.this.isAnnotated ? ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).save(entity) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? (method == HttpMethod.POST ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).create(entity) : ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).save(entity)) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).save(entity) : ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).save(entity)));
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forSave(this.moduleRegistry, method, queryAdapter, entity);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse delete(I id, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Serializable id = request.getId();
                if (ResourceRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).delete(id, queryAdapter);
                } else if (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2) {
                    ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).delete(id);
                } else {
                    ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).delete(id);
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forDelete(this.moduleRegistry, queryAdapter, id);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public Object getResourceRepository() {
        return this.resourceRepository;
    }

    @Override
    protected ResourceInformation getResourceInformation(Object repository) {
        return this.resourceInformation;
    }
}

