/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.utils;

import io.katharsis.errorhandling.exception.ResourceException;
import io.katharsis.utils.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ClassUtils {
    private ClassUtils() {
    }

    public static List<Field> getClassFields(Class<?> beanClass) {
        HashMap<String, Field> result = new HashMap<String, Field>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                Field v;
                if (field.isSynthetic() || (v = (Field)result.get(field.getName())) != null) continue;
                result.put(field.getName(), field);
            }
        }
        return new LinkedList<Field>(result.values());
    }

    public static <T extends Annotation> Optional<T> getAnnotation(Class<?> beanClass, Class<T> annotationClass) {
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!currentClass.isAnnotationPresent(annotationClass)) continue;
            return Optional.of(currentClass.getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    public static Field findClassField(Class<?> beanClass, String fieldName) {
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (field.isSynthetic() || !field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static Method findGetter(Class<?> beanClass, String fieldName) {
        String upperCaseName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return beanClass.getMethod("get" + upperCaseName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = beanClass.getMethod("is" + upperCaseName, new Class[0]);
                Class<?> returnType = method.getReturnType();
                if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                    return method;
                }
                return null;
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
    }

    public static Method findSetter(Class<?> beanClass, String fieldName, Class<?> fieldType) {
        String upperCaseName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return beanClass.getMethod("set" + upperCaseName, fieldType);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    public static List<Method> getClassGetters(Class<?> beanClass) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                Method v;
                if (method.isSynthetic() || !ClassUtils.isGetter(method) || (v = (Method)result.get(method.getName())) != null) continue;
                result.put(method.getName(), method);
            }
        }
        return new LinkedList<Method>(result.values());
    }

    public static List<Method> getClassSetters(Class<?> beanClass) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                Method v;
                if (method.isSynthetic() || !ClassUtils.isSetter(method) || (v = (Method)result.get(method.getName())) != null) continue;
                result.put(method.getName(), method);
            }
        }
        return new LinkedList<Method>(result.values());
    }

    public static Method findMethodWith(Class<?> searchClass, Class<? extends Annotation> annotationClass) {
        Method foundMethod = null;
        block0: while (searchClass != null && searchClass != Object.class) {
            for (Method method : searchClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                foundMethod = method;
                break block0;
            }
            searchClass = searchClass.getSuperclass();
        }
        return foundMethod;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ResourceException(String.format("couldn't create a new instance of %s", clazz));
        }
    }

    private static boolean isGetter(Method method) {
        return ClassUtils.isBooleanGetter(method) || ClassUtils.isNonBooleanGetter(method);
    }

    public static boolean isBooleanGetter(Method method) {
        if (!method.getName().startsWith("is")) {
            return false;
        }
        if (method.getName().length() < 3) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType());
    }

    private static boolean isNonBooleanGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getName().length() < 4) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    private static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getName().length() < 4) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.getRawType(((ParameterizedType)type).getRawType());
        }
        throw new IllegalStateException("unknown type: " + type);
    }
}

