/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.utils;

import io.katharsis.core.internal.utils.PreconditionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultivaluedMap<K, V> {
    private Map<K, List<V>> map = new HashMap<K, List<V>>();

    public void add(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = this.newList();
            this.map.put(key, list);
        }
        list.add(value);
    }

    protected List<V> newList() {
        return new ArrayList();
    }

    public void addAll(K key, Iterable<V> values) {
        for (V value : values) {
            this.add(key, value);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public V getUnique(K key) {
        List<V> list = this.map.get(key);
        if (list.size() > 1) {
            throw new IllegalStateException("expected unique key=" + key + ", got=" + list);
        }
        return list.get(0);
    }

    public List<V> getList(K key) {
        List<V> list = this.map.get(key);
        PreconditionUtil.assertNotNull("key not available", list);
        return list;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void set(K key, List<V> values) {
        this.map.put(key, values);
    }
}

