/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.registry;

import io.katharsis.errorhandling.exception.RepositoryInstanceNotFoundException;
import io.katharsis.legacy.locator.JsonServiceLocator;

public class RepositoryInstanceBuilder<T> {
    private final JsonServiceLocator jsonServiceLocator;
    private final Class<T> repositoryClass;

    public RepositoryInstanceBuilder(JsonServiceLocator jsonServiceLocator, Class<T> repositoryClass) {
        this.jsonServiceLocator = jsonServiceLocator;
        this.repositoryClass = repositoryClass;
    }

    public T buildRepository() {
        T repoInstance = this.jsonServiceLocator.getInstance(this.repositoryClass);
        if (repoInstance == null) {
            throw new RepositoryInstanceNotFoundException(this.repositoryClass.getCanonicalName());
        }
        return repoInstance;
    }

    public Class<T> getRepositoryClass() {
        return this.repositoryClass;
    }
}

