/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.utils.parser;

import io.katharsis.utils.parser.DefaultStringParsers;
import io.katharsis.utils.parser.ParserException;
import io.katharsis.utils.parser.StringParser;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class TypeParser {
    public final Map<Class, StringParser> parsers = new HashMap<Class, StringParser>();

    public TypeParser() {
        this.parsers.putAll(DefaultStringParsers.get());
    }

    public <T> void addParser(Class<T> clazz, StringParser<T> parser) {
        this.parsers.put(clazz, parser);
    }

    public <T extends Serializable> Iterable<T> parse(Iterable<String> inputs, Class<T> clazz) {
        LinkedList<T> parsedValues = new LinkedList<T>();
        for (String input : inputs) {
            parsedValues.add(this.parse(input, clazz));
        }
        return parsedValues;
    }

    public <T extends Serializable> T parse(String input, Class<T> clazz) {
        try {
            return this.parseInput(input, clazz);
        }
        catch (ParserException | IllegalAccessException | InstantiationException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            throw new ParserException(e.getMessage());
        }
    }

    private <T extends Serializable> T parseInput(String input, Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (String.class.equals(clazz)) {
            return (T)input;
        }
        if (this.parsers.containsKey(clazz)) {
            StringParser standardTypeParser = this.parsers.get(clazz);
            return (T)((Serializable)standardTypeParser.parse(input));
        }
        if (TypeParser.isEnum(clazz)) {
            return (T)Enum.valueOf(clazz.asSubclass(Enum.class), input.trim());
        }
        if (this.containsStringConstructor(clazz)) {
            return (T)((Serializable)clazz.getDeclaredConstructor(String.class).newInstance(input));
        }
        try {
            Method method = clazz.getMethod("parse", String.class);
            return (T)((Serializable)method.invoke(clazz, input));
        }
        catch (NoSuchMethodException e) {
            throw new ParserException(String.format("Cannot parse to %s : %s", clazz.getName(), input));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T extends Serializable> boolean isEnum(Class<T> clazz) {
        return clazz.isEnum();
    }

    private boolean containsStringConstructor(Class<?> clazz) throws NoSuchMethodException {
        boolean result = false;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != String.class) continue;
            result = true;
        }
        return result;
    }
}

