/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.invoker.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import io.katharsis.core.internal.boot.KatharsisBoot;
import io.katharsis.core.internal.boot.PropertiesProvider;
import io.katharsis.core.internal.dispatcher.RequestDispatcher;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.dispatcher.path.PathBuilder;
import io.katharsis.core.internal.exception.KatharsisExceptionMapper;
import io.katharsis.errorhandling.exception.JsonDeserializationException;
import io.katharsis.errorhandling.exception.KatharsisMappableException;
import io.katharsis.errorhandling.exception.KatharsisMatchingException;
import io.katharsis.invoker.internal.JsonApiMediaType;
import io.katharsis.invoker.internal.KatharsisInvokerContext;
import io.katharsis.invoker.internal.KatharsisInvokerException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.module.Module;
import io.katharsis.queryspec.QuerySpecDeserializer;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import io.katharsis.servlet.internal.QueryStringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class KatharsisInvokerV2 {
    private static int BUFFER_SIZE = 4096;
    private KatharsisBoot boot = new KatharsisBoot();

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.boot.setServiceUrlProvider(serviceUrlProvider);
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.boot.setPropertiesProvider(propertiesProvider);
    }

    public void addModule(Module module) {
        this.boot.addModule(module);
    }

    public ObjectMapper getObjectMapper() {
        return this.boot.getObjectMapper();
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        this.boot.setDefaultPageLimit(defaultPageLimit);
    }

    public QuerySpecDeserializer getQuerySpecDeserializer() {
        return this.boot.getQuerySpecDeserializer();
    }

    public KatharsisBoot getBoot() {
        return this.boot;
    }

    public void configure() {
        this.boot.boot();
    }

    public void invoke(KatharsisInvokerContext invokerContext) throws KatharsisInvokerException {
        if (this.isAcceptableMediaType(invokerContext)) {
            try {
                this.dispatchRequest(invokerContext);
            }
            catch (Exception e) {
                throw new KatharsisInvokerException(500, (Throwable)e);
            }
        } else {
            throw new KatharsisInvokerException(415, "Unsupported Media Type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dispatchRequest(KatharsisInvokerContext invokerContext) throws Exception {
        block22: {
            InputStream in;
            boolean passToMethodMatcher;
            Response katharsisResponse;
            block21: {
                katharsisResponse = null;
                passToMethodMatcher = false;
                in = null;
                ResourceRegistry resourceRegistry = this.boot.getResourceRegistry();
                RequestDispatcher requestDispatcher = this.boot.getRequestDispatcher();
                JsonPath jsonPath = new PathBuilder(resourceRegistry).buildPath(invokerContext.getRequestPath());
                Map<String, Set<String>> parameters = this.getParameters(invokerContext);
                in = invokerContext.getRequestEntityStream();
                Document requestBody = this.inputStreamToBody(in);
                String method = invokerContext.getRequestMethod();
                RepositoryMethodParameterProvider parameterProvider = invokerContext.getParameterProvider();
                katharsisResponse = requestDispatcher.dispatchRequest(jsonPath, method, parameters, parameterProvider, requestBody);
                this.closeQuietly(in);
                if (katharsisResponse == null) break block21;
                invokerContext.setResponseStatus(katharsisResponse.getHttpStatus());
                invokerContext.setResponseContentType("application/vnd.api+json;charset=UTF-8");
                ByteArrayOutputStream baos = null;
                OutputStream out = null;
                try {
                    baos = new ByteArrayOutputStream(BUFFER_SIZE);
                    ObjectMapper objectMapper = this.boot.getObjectMapper();
                    objectMapper.writeValue((OutputStream)baos, (Object)katharsisResponse.getDocument());
                    out = invokerContext.getResponseOutputStream();
                    out.write(baos.toByteArray());
                    out.flush();
                    this.closeQuietly(baos);
                    this.closeQuietly(out);
                }
                catch (Throwable throwable) {
                    this.closeQuietly(baos);
                    this.closeQuietly(out);
                    throw throwable;
                }
            }
            if (passToMethodMatcher) {
                invokerContext.setResponseStatus(404);
            } else {
                invokerContext.setResponseStatus(204);
            }
            break block22;
            catch (KatharsisMappableException e) {
                katharsisResponse = new KatharsisExceptionMapper().toErrorResponse(e).toResponse();
                break block22;
            }
            catch (KatharsisMatchingException e2) {
                passToMethodMatcher = true;
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeQuietly(in);
                if (katharsisResponse != null) {
                    invokerContext.setResponseStatus(katharsisResponse.getHttpStatus());
                    invokerContext.setResponseContentType("application/vnd.api+json;charset=UTF-8");
                    ByteArrayOutputStream baos = null;
                    OutputStream out = null;
                    try {
                        baos = new ByteArrayOutputStream(BUFFER_SIZE);
                        ObjectMapper objectMapper = this.boot.getObjectMapper();
                        objectMapper.writeValue((OutputStream)baos, (Object)katharsisResponse.getDocument());
                        out = invokerContext.getResponseOutputStream();
                        out.write(baos.toByteArray());
                        out.flush();
                        this.closeQuietly(baos);
                        this.closeQuietly(out);
                    }
                    catch (Throwable throwable) {
                        this.closeQuietly(baos);
                        this.closeQuietly(out);
                        throw throwable;
                    }
                } else if (passToMethodMatcher) {
                    invokerContext.setResponseStatus(404);
                } else {
                    invokerContext.setResponseStatus(204);
                }
            }
        }
    }

    private boolean isAcceptableMediaType(KatharsisInvokerContext invokerContext) {
        String acceptHeader = invokerContext.getRequestHeader("Accept");
        if (acceptHeader != null) {
            String[] accepts;
            for (String mediaTypeItem : accepts = acceptHeader.split(",")) {
                MediaType acceptableType = MediaType.parse((String)mediaTypeItem.trim());
                if (!JsonApiMediaType.isCompatibleMediaType(acceptableType)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Set<String>> getParameters(KatharsisInvokerContext invokerContext) {
        return QueryStringUtils.parseQueryStringAsSingleValueMap(invokerContext);
    }

    private Document inputStreamToBody(InputStream is) throws IOException {
        String requestBody;
        if (is == null) {
            return null;
        }
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        String string = requestBody = s.hasNext() ? s.next() : "";
        if (requestBody == null || requestBody.isEmpty()) {
            return null;
        }
        try {
            ObjectMapper objectMapper = this.boot.getObjectMapper();
            return (Document)objectMapper.readValue(requestBody, Document.class);
        }
        catch (IOException e) {
            throw new JsonDeserializationException(e.getMessage());
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

