/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.invoker.internal.KatharsisInvokerContext;
import io.katharsis.invoker.internal.KatharsisInvokerException;
import io.katharsis.invoker.internal.KatharsisInvokerV2;
import io.katharsis.module.Module;
import io.katharsis.queryspec.QuerySpecDeserializer;
import io.katharsis.resource.registry.ServiceUrlProvider;
import io.katharsis.servlet.internal.ServletKatharsisInvokerContext;
import io.katharsis.servlet.internal.ServletModule;
import io.katharsis.servlet.internal.ServletPropertiesProvider;
import io.katharsis.servlet.internal.ServletUrlProvider;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KatharsisServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(KatharsisServlet.class);
    private ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();
    private KatharsisInvokerV2 katharsisInvoker;
    private ServletUrlProvider servletUrlProvider;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        KatharsisInvokerContext invokerContext = this.createKatharsisInvokerContext(request, response);
        try {
            this.requestThreadLocal.set(request);
            this.getKatharsisInvoker().invoke(invokerContext);
        }
        catch (KatharsisInvokerException e) {
            log.warn("Katharsis Invoker exception.", (Throwable)e);
            response.setStatus(e.getStatusCode());
        }
        catch (Exception e) {
            throw new ServletException("Katharsis invocation failed.", (Throwable)e);
        }
        finally {
            this.requestThreadLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KatharsisInvokerV2 getKatharsisInvoker() {
        KatharsisInvokerV2 invoker = this.katharsisInvoker;
        if (invoker == null) {
            KatharsisServlet katharsisServlet = this;
            synchronized (katharsisServlet) {
                invoker = this.katharsisInvoker;
                if (invoker == null) {
                    invoker = this.createKatharsisInvoker();
                    invoker.configure();
                    this.katharsisInvoker = invoker;
                }
            }
        }
        return invoker;
    }

    public void setKatharsisInvoker(KatharsisInvokerV2 katharsisInvoker) {
        this.katharsisInvoker = katharsisInvoker;
    }

    protected KatharsisInvokerContext createKatharsisInvokerContext(HttpServletRequest request, HttpServletResponse response) {
        return new ServletKatharsisInvokerContext(this.getServletContext(), request, response);
    }

    protected KatharsisInvokerV2 createKatharsisInvoker() {
        this.servletUrlProvider = new ServletUrlProvider(this.requestThreadLocal);
        KatharsisInvokerV2 invoker = new KatharsisInvokerV2();
        invoker.setPropertiesProvider(new ServletPropertiesProvider(this.getServletConfig()));
        invoker.getBoot().setDefaultServiceUrlProvider((ServiceUrlProvider)this.servletUrlProvider);
        invoker.addModule(new ServletModule(this.requestThreadLocal));
        return invoker;
    }

    public void addModule(Module module) {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        invoker.addModule(module);
    }

    public ObjectMapper getObjectMapper() {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        return invoker.getObjectMapper();
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        invoker.setDefaultPageLimit(defaultPageLimit);
    }

    public QuerySpecDeserializer getQuerySpecDeserializer() {
        KatharsisInvokerV2 invoker = this.getKatharsisInvoker();
        return invoker.getQuerySpecDeserializer();
    }
}

