/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.servlet.internal;

import io.katharsis.invoker.internal.KatharsisInvokerContext;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.servlet.internal.ServletParametersProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletKatharsisInvokerContext
implements KatharsisInvokerContext {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ServletKatharsisInvokerContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
    }

    @Override
    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public String getRequestPath() {
        String path = this.request.getPathInfo();
        if (path == null) {
            path = this.request.getRequestURI().substring(this.request.getContextPath().length());
        }
        return path;
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRequestQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public String[] getQueryParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    @Override
    public String getQueryParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public InputStream getRequestEntityStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public void setResponseStatus(int sc) {
        this.response.setStatus(sc);
    }

    @Override
    public void setResponseContentType(String type) {
        this.response.setContentType(type);
    }

    @Override
    public OutputStream getResponseOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    @Override
    public RepositoryMethodParameterProvider getParameterProvider() {
        return new ServletParametersProvider(this.servletContext, this.request, this.response);
    }
}

