/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.errorhandling.ErrorResponse;
import io.katharsis.errorhandling.mapper.JsonApiExceptionMapper;
import io.katharsis.invoker.internal.KatharsisInvokerException;
import io.katharsis.utils.Optional;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Priority;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

@Priority(value=10)
public class ErrorHandlerFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlerFilter.class);
    private ObjectMapper objectMapper;
    private ExceptionMapperRegistry exceptionMapperRegistry;

    public ErrorHandlerFilter(ObjectMapper objectMapper, ExceptionMapperRegistry exceptionMapperRegistry) {
        this.objectMapper = objectMapper;
        this.exceptionMapperRegistry = exceptionMapperRegistry;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (KatharsisInvokerException e) {
            Optional mapper = this.exceptionMapperRegistry.findMapperFor(e.getCause().getClass());
            if (!mapper.isPresent()) {
                throw e;
            }
            ErrorResponse errorResponse = ((JsonApiExceptionMapper)mapper.get()).toErrorResponse(e.getCause());
            response.setStatus(errorResponse.getHttpStatus());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.objectMapper.writeValue((OutputStream)baos, (Object)errorResponse.toResponse());
            try (ServletOutputStream out = response.getOutputStream();){
                out.write(baos.toByteArray());
                out.flush();
            }
            log.warn("Katharsis Invoker exception.", (Throwable)e);
        }
    }
}

