/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import io.katharsis.core.internal.dispatcher.RequestDispatcher;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.dispatcher.path.PathBuilder;
import io.katharsis.core.internal.exception.KatharsisExceptionMapper;
import io.katharsis.errorhandling.exception.JsonDeserializationException;
import io.katharsis.errorhandling.exception.KatharsisMappableException;
import io.katharsis.errorhandling.exception.KatharsisMatchingException;
import io.katharsis.invoker.internal.JsonApiMediaType;
import io.katharsis.invoker.internal.KatharsisInvokerException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.servlet.internal.BufferedRequestWrapper;
import io.katharsis.spring.SpringParameterProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Priority;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

@Priority(value=20)
public class KatharsisFilterV2
implements Filter,
BeanFactoryAware {
    private static final int BUFFER_SIZE = 4096;
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private RequestDispatcher requestDispatcher;
    private String webPathPrefix;
    private ConfigurableBeanFactory beanFactory;

    public KatharsisFilterV2(ObjectMapper objectMapper, ResourceRegistry resourceRegistry, RequestDispatcher requestDispatcher, String webPathPrefix) {
        this.objectMapper = objectMapper;
        this.resourceRegistry = resourceRegistry;
        this.requestDispatcher = requestDispatcher;
        this.webPathPrefix = webPathPrefix != null ? webPathPrefix : "";
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse && this.isAcceptablePath((HttpServletRequest)req)) {
            BufferedRequestWrapper request = new BufferedRequestWrapper((HttpServletRequest)req);
            HttpServletResponse response = (HttpServletResponse)res;
            req.setCharacterEncoding("UTF-8");
            boolean passToFilters = this.invoke((HttpServletRequest)request, response);
            if (passToFilters) {
                chain.doFilter((ServletRequest)request, res);
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    private boolean invoke(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAcceptablePath(request)) {
            return true;
        }
        if (this.isAcceptableMediaType(request)) {
            try {
                return this.dispatchRequest(request, response);
            }
            catch (Exception e) {
                throw new KatharsisInvokerException(500, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean passToFilters;
        block18: {
            ServletInputStream in;
            Response katharsisResponse;
            block19: {
                katharsisResponse = null;
                passToFilters = false;
                in = null;
                JsonPath jsonPath = new PathBuilder(this.resourceRegistry).buildPath(this.getRequestPath(request));
                Map<String, Set<String>> parameters = this.getParameters(request);
                in = request.getInputStream();
                Document requestBody = this.inputStreamToBody((InputStream)in);
                String method = request.getMethod();
                SpringParameterProvider parameterProvider = new SpringParameterProvider(this.beanFactory, request);
                katharsisResponse = this.requestDispatcher.dispatchRequest(jsonPath, method, parameters, (RepositoryMethodParameterProvider)parameterProvider, requestBody);
                if (passToFilters) break block18;
                this.closeQuietly((Closeable)in);
                if (katharsisResponse == null) break block19;
                response.setStatus(katharsisResponse.getHttpStatus().intValue());
                response.setContentType("application/vnd.api+json;charset=UTF-8");
                ByteArrayOutputStream baos = null;
                ServletOutputStream out = null;
                try {
                    baos = new ByteArrayOutputStream(4096);
                    this.objectMapper.writeValue((OutputStream)baos, (Object)katharsisResponse.getDocument());
                    out = response.getOutputStream();
                    out.write(baos.toByteArray());
                    out.flush();
                    this.closeQuietly(baos);
                    this.closeQuietly((Closeable)out);
                }
                catch (Throwable throwable) {
                    this.closeQuietly(baos);
                    this.closeQuietly((Closeable)out);
                    throw throwable;
                }
            }
            response.setStatus(204);
            break block18;
            catch (KatharsisMappableException e) {
                katharsisResponse = new KatharsisExceptionMapper().toErrorResponse(e).toResponse();
                break block18;
            }
            catch (KatharsisMatchingException e2) {
                passToFilters = true;
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!passToFilters) {
                    this.closeQuietly((Closeable)in);
                    if (katharsisResponse != null) {
                        response.setStatus(katharsisResponse.getHttpStatus().intValue());
                        response.setContentType("application/vnd.api+json;charset=UTF-8");
                        ByteArrayOutputStream baos = null;
                        ServletOutputStream out = null;
                        try {
                            baos = new ByteArrayOutputStream(4096);
                            this.objectMapper.writeValue((OutputStream)baos, (Object)katharsisResponse.getDocument());
                            out = response.getOutputStream();
                            out.write(baos.toByteArray());
                            out.flush();
                            this.closeQuietly(baos);
                            this.closeQuietly((Closeable)out);
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(baos);
                            this.closeQuietly((Closeable)out);
                            throw throwable;
                        }
                    } else {
                        response.setStatus(204);
                    }
                }
            }
        }
        return passToFilters;
    }

    private boolean isAcceptablePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath.startsWith("/") && contextPath.length() == 1) {
            contextPath = "";
        }
        return request.getRequestURI().startsWith(contextPath + this.webPathPrefix);
    }

    private String getRequestPath(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            path = request.getRequestURI().substring(request.getContextPath().length() + this.webPathPrefix.length());
        }
        return path;
    }

    private boolean isAcceptableMediaType(HttpServletRequest servletRequest) {
        String acceptHeader = servletRequest.getHeader("Accept");
        if (acceptHeader != null) {
            String[] accepts;
            for (String mediaTypeItem : accepts = acceptHeader.split(",")) {
                try {
                    MediaType acceptableType = MediaType.parse((String)mediaTypeItem.trim());
                    if (JsonApiMediaType.isCompatibleMediaType((MediaType)acceptableType)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private Map<String, Set<String>> getParameters(HttpServletRequest request) {
        Map params = request.getParameterMap();
        HashMap<String, Set<String>> queryParameters = new HashMap<String, Set<String>>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            queryParameters.put((String)entry.getKey(), (Set<String>)new HashSet<Object>(Arrays.asList((Object[])entry.getValue())));
        }
        return queryParameters;
    }

    private Document inputStreamToBody(InputStream is) {
        String requestBody;
        if (is == null) {
            return null;
        }
        Scanner s = new Scanner(is).useDelimiter("\\A");
        String string = requestBody = s.hasNext() ? s.next() : "";
        if (requestBody == null || requestBody.isEmpty()) {
            return null;
        }
        try {
            return (Document)this.objectMapper.readValue(requestBody, Document.class);
        }
        catch (IOException e) {
            throw new JsonDeserializationException(e.getMessage());
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }
}

