/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.spring.boot.autoconfigure;

import io.katharsis.core.internal.boot.TransactionRunner;
import io.katharsis.jpa.JpaModule;
import io.katharsis.jpa.query.JpaQueryFactory;
import io.katharsis.jpa.query.criteria.JpaCriteriaQueryFactory;
import io.katharsis.jpa.query.querydsl.QuerydslQueryFactory;
import io.katharsis.spring.boot.KatharsisJpaProperties;
import io.katharsis.spring.boot.KatharsisSpringBootProperties;
import io.katharsis.spring.boot.v3.KatharsisConfigV3;
import io.katharsis.spring.jpa.SpringTransactionRunner;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnBean(value={EntityManager.class, EntityManagerFactory.class})
@ConditionalOnClass(value={JpaModule.class})
@ConditionalOnProperty(prefix="katharsis.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={JpaModule.class})
@EnableConfigurationProperties(value={KatharsisJpaProperties.class, KatharsisSpringBootProperties.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@AutoConfigureBefore
@Import(value={KatharsisConfigV3.class})
public class KatharsisJpaAutoConfiguration {
    @Autowired
    private EntityManager em;
    @Autowired
    private EntityManagerFactory emf;
    @Autowired
    private KatharsisJpaProperties jpaProperties;

    @Bean
    public SpringTransactionRunner transactionRunner() {
        return new SpringTransactionRunner();
    }

    @Bean
    public JpaModule jpaModule() {
        JpaModule module = JpaModule.newServerModule((EntityManagerFactory)this.emf, (EntityManager)this.em, (TransactionRunner)this.transactionRunner());
        if (this.jpaProperties.getQueryFactory() != null) {
            switch (this.jpaProperties.getQueryFactory()) {
                case CRITERIA: {
                    module.setQueryFactory((JpaQueryFactory)JpaCriteriaQueryFactory.newInstance());
                    break;
                }
                case QUERYDSL: {
                    module.setQueryFactory((JpaQueryFactory)QuerydslQueryFactory.newInstance());
                }
            }
        }
        return module;
    }
}

