/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import antlr.CharScanner;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateGroupLoader;

public class ClasspathGroupLoader
implements StringTemplateGroupLoader {
    private String fileCharEncoding = System.getProperty("file.encoding");
    private final ConcurrentMap<String, StringTemplateGroup> groupCache = new ConcurrentHashMap<String, StringTemplateGroup>();
    private final ConcurrentMap<String, StringTemplateGroupInterface> interfaceCache = new ConcurrentHashMap<String, StringTemplateGroupInterface>();
    private final Class<? extends CharScanner> lexerClass;
    private final StringTemplateErrorListener errors;
    private final String[] dirs;

    public ClasspathGroupLoader(Class<? extends CharScanner> clazz, StringTemplateErrorListener stringTemplateErrorListener, String ... stringArray) {
        this.lexerClass = clazz;
        this.errors = stringTemplateErrorListener;
        this.dirs = stringArray;
    }

    public ClasspathGroupLoader(StringTemplateErrorListener stringTemplateErrorListener, String ... stringArray) {
        this(null, stringTemplateErrorListener, stringArray);
    }

    public ClasspathGroupLoader(StringTemplateErrorListener stringTemplateErrorListener) {
        this(stringTemplateErrorListener, "/");
    }

    public ClasspathGroupLoader(String ... stringArray) {
        this(new ExplodingStringTemplateErrorListener(), stringArray);
    }

    public ClasspathGroupLoader(Class<? extends CharScanner> clazz, String ... stringArray) {
        this(clazz, new ExplodingStringTemplateErrorListener(), stringArray);
    }

    public ClasspathGroupLoader() {
        this("/");
    }

    private BufferedReader locate(String string) {
        for (String string2 : this.dirs) {
            String string3 = string2 + "/" + string;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string3);
            if (inputStream == null) {
                classLoader = this.getClass().getClassLoader();
                inputStream = classLoader.getResourceAsStream(string3);
            }
            if (inputStream == null) continue;
            return new BufferedReader(this.getInputStreamReader(inputStream));
        }
        return null;
    }

    public StringTemplateGroup loadGroup(String string) {
        if (this.groupCache.containsKey(string)) {
            return (StringTemplateGroup)this.groupCache.get(string);
        }
        BufferedReader bufferedReader = this.locate(string + ".stg");
        if (bufferedReader == null) {
            this.errors.error("no such group file " + string + ".stg", null);
            return null;
        }
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)bufferedReader, this.lexerClass, this.errors);
        this.groupCache.putIfAbsent(string, stringTemplateGroup);
        return stringTemplateGroup;
    }

    public StringTemplateGroup loadGroup(String string, StringTemplateGroup stringTemplateGroup) {
        String string2 = string + "!@#$%^&*()" + stringTemplateGroup;
        if (this.groupCache.containsKey(string2)) {
            return (StringTemplateGroup)this.groupCache.get(string2);
        }
        BufferedReader bufferedReader = this.locate(string + ".stg");
        if (bufferedReader == null) {
            this.errors.error("no such group file " + string + ".stg", null);
            return null;
        }
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup((Reader)bufferedReader, this.lexerClass, this.errors, stringTemplateGroup);
        this.groupCache.putIfAbsent(string2, stringTemplateGroup2);
        return stringTemplateGroup2;
    }

    public StringTemplateGroupInterface loadInterface(String string) {
        if (this.interfaceCache.containsKey(string)) {
            return (StringTemplateGroupInterface)this.interfaceCache.get(string);
        }
        BufferedReader bufferedReader = this.locate(string + ".sti");
        if (bufferedReader == null) {
            this.errors.error("no such interface file " + string + ".sti", null);
            return null;
        }
        StringTemplateGroupInterface stringTemplateGroupInterface = new StringTemplateGroupInterface((Reader)bufferedReader, this.errors);
        this.interfaceCache.put(string, stringTemplateGroupInterface);
        return stringTemplateGroupInterface;
    }

    private InputStreamReader getInputStreamReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errors.error("Invalid file character encoding: " + this.fileCharEncoding, null);
        }
        return inputStreamReader;
    }

    public void setFileCharEncoding(String string) {
        this.fileCharEncoding = string;
    }

    private static class ExplodingStringTemplateErrorListener
    implements StringTemplateErrorListener {
        private ExplodingStringTemplateErrorListener() {
        }

        public void error(String string, Throwable throwable) {
            throw new IllegalStateException(string, throwable);
        }

        public void warning(String string) {
            throw new IllegalStateException(string);
        }
    }
}

