/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import io.kazuki.v0.internal.helper.SqlTypeHelper;
import io.kazuki.v0.internal.v2schema.Attribute;

public class H2TypeHelper
implements SqlTypeHelper {
    public static final String DATABASE_PREFIX = "h2:h2_";

    @Override
    public String getPrefix() {
        return DATABASE_PREFIX;
    }

    @Override
    public String getSqlType(Attribute.Type type) {
        switch (type) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case ENUM: {
                return "SMALLINT";
            }
            case I8: {
                return "TINYINT";
            }
            case I16: {
                return "SMALLINT";
            }
            case I32: {
                return "INT";
            }
            case I64: {
                return "BIGINT";
            }
            case U8: {
                return "SMALLINT";
            }
            case U16: {
                return "INT";
            }
            case U32: {
                return "BIGINT";
            }
            case U64: {
                return "BIGINT UNSIGNED";
            }
            case UTC_DATE_SECS: {
                return "BIGINT";
            }
            case UTF8_SMALLSTRING: {
                return "VARCHAR(255)";
            }
            case CHAR_ONE: {
                return "CHAR(1)";
            }
        }
        throw new IllegalArgumentException("Unsupported type in index: " + (Object)((Object)type));
    }

    @Override
    public String getInsertIgnore() {
        return "insert ";
    }

    @Override
    public String getPKConflictResolve() {
        return "";
    }

    @Override
    public boolean isDuplicateKeyException(Throwable throwable) {
        return throwable.getMessage().indexOf("Unique index or primary key violation") >= 0;
    }

    @Override
    public boolean isTableAlreadyExistsException(Throwable throwable) {
        return throwable.getMessage().indexOf(" already exists;") >= 0;
    }

    @Override
    public String quote(String string) {
        return "\"" + string + "\"";
    }

    @Override
    public String getTableOptions() {
        return "";
    }
}

