/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import io.kazuki.v0.internal.helper.ClasspathGroupLoader;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class JDBIHelper {
    public static DBI getDBI(Class<?> clazz, DataSource dataSource) {
        DBI dBI = new DBI(dataSource);
        final ClasspathGroupLoader classpathGroupLoader = new ClasspathGroupLoader(AngleBracketTemplateLexer.class, clazz.getPackage().getName().replaceAll("\\.", "/"));
        dBI.setStatementLocator(new StatementLocator(){
            private final StringTemplateGroupLoader loader;
            {
                this.loader = classpathGroupLoader;
            }

            public String locate(String string, StatementContext statementContext) throws Exception {
                if (ClasspathStatementLocator.looksLikeSql((String)string)) {
                    return string;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                StringTemplateGroup stringTemplateGroup = this.loader.loadGroup(string2);
                StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf(string3);
                stringTemplate.setAttributes(statementContext.getAttributes());
                return stringTemplate.toString();
            }
        });
        return dBI;
    }

    public static Query<Map<String, Object>> getBoundQuery(Handle handle, String string, String string2, String string3, String string4) {
        return (Query)handle.createQuery(string + string4).define(string2, (Object)string3);
    }

    public static Update getBoundStatement(Handle handle, String string, String string2, String string3, String string4) {
        return (Update)handle.createStatement(string + string4).define(string2, (Object)string3);
    }

    public static void createTable(IDBI iDBI, final String string, final String string2) {
        iDBI.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                handle.createStatement(string).execute();
                handle.createStatement(string2).execute();
                return null;
            }
        });
    }

    public static void dropTable(IDBI iDBI, final String string) {
        iDBI.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                JDBIHelper.dropTable(handle, string);
                return null;
            }
        });
    }

    public static void dropTable(Handle handle, String string) {
        handle.createStatement(string).execute();
    }

    public static boolean tableExists(IDBI iDBI, final String string, final String string2) {
        if (string2 == null) {
            return false;
        }
        return (Boolean)iDBI.inTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                try {
                    ((Update)handle.createStatement(string + "table_exists").define("table_name", (Object)string2)).execute();
                    return true;
                }
                catch (UnableToExecuteStatementException unableToExecuteStatementException) {
                }
                catch (UnableToCreateStatementException unableToCreateStatementException) {
                    // empty catch block
                }
                return false;
            }
        });
    }
}

