/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MaskProxy<T, U extends T>
implements InvocationHandler {
    private final Class<T> iface;
    private volatile U delegate;
    private final InvocationHandler finalHandler;
    public static final InvocationHandler UNSUPPORTED_OPERATION_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            throw new UnsupportedOperationException();
        }
    };

    public Class<T> getInterface() {
        return this.iface;
    }

    public MaskProxy(Class<T> clazz, U u) {
        this.iface = clazz;
        this.delegate = u;
        this.finalHandler = UNSUPPORTED_OPERATION_HANDLER;
    }

    public U getAndSet(U u) {
        U u2 = this.delegate;
        this.delegate = u;
        return u2;
    }

    public T asProxyInstance() {
        return (T)Proxy.newProxyInstance(this.iface.getClassLoader(), new Class[]{this.iface}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.iface.getMethod(method.getName(), method.getParameterTypes()) == null) {
            return this.finalHandler.invoke(object, method, objectArray);
        }
        try {
            return this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.delegate, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        return this.finalHandler.invoke(object, method, objectArray);
    }
}

