/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.serialize.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kazuki.v0.internal.serialize.SerializationException;
import io.kazuki.v0.internal.serialize.Serializer;

public class JsonCodec<T>
implements Serializer<T> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<T> theClass;

    public JsonCodec(Class<T> clazz) {
        this.theClass = clazz;
    }

    @Override
    public T decode(byte[] byArray) throws SerializationException {
        try {
            return (T)this.mapper.readValue(byArray, this.theClass);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    @Override
    public byte[] encode(Object object) throws SerializationException {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }
}

