/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.kazuki.v0.internal.serialize.SerializationException;
import io.kazuki.v0.internal.serialize.Serializer;

public class KryoCodec<T>
implements Serializer<T> {
    private final Class<T> theClass;

    public KryoCodec(Class<T> clazz) {
        this.theClass = clazz;
    }

    @Override
    public T decode(byte[] byArray) throws SerializationException {
        Kryo kryo = new Kryo();
        try {
            return (T)kryo.readObject(new Input(byArray), this.theClass);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    @Override
    public byte[] encode(Object object) throws SerializationException {
        Kryo kryo = new Kryo();
        try {
            Output output = new Output();
            kryo.writeObject(output, object);
            return output.toBytes();
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }
}

