/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kazuki.v0.internal.v2schema.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Attribute {
    public static Schema ATTRIBUTE_SCHEMA;
    private final String name;
    private final Type type;
    private final List<String> values;
    private final boolean nullable;

    @JsonCreator
    public Attribute(@JsonProperty(value="name") String string, @JsonProperty(value="type") Type type, @JsonProperty(value="values") List<Object> list, @JsonProperty(value="nullable") Boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute 'name' must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Attribute 'type' must be specified");
        }
        this.name = string;
        this.type = type;
        boolean bl2 = this.nullable = bl == null || bl != false;
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : list) {
                arrayList.add(object.toString());
            }
            this.values = Collections.unmodifiableList(arrayList);
        } else {
            this.values = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public List<String> getValues() {
        return this.values;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    static {
        Schema.Builder builder = new Schema.Builder();
        builder.addAttribute("name", Type.UTF8_SMALLSTRING, false);
        builder.addAttribute("type", Type.ENUM, Arrays.asList((Object[])Type.values()), false);
        builder.addAttribute("nullable", Type.BOOLEAN, true);
        builder.addAttribute("values", Type.ARRAY, true);
        ATTRIBUTE_SCHEMA = builder.build();
    }

    public static enum Type {
        ANY,
        MAP,
        ARRAY,
        BOOLEAN,
        CHAR_ONE,
        ENUM,
        U8,
        U16,
        U32,
        U64,
        I8,
        I16,
        I32,
        I64,
        UTC_DATE_SECS,
        UTF8_SMALLSTRING,
        UTF8_TEXT;

    }
}

