/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kazuki.v0.internal.v2schema.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema {
    public static Schema SCHEMA_SCHEMA = new Builder().addAttribute("attributes", Attribute.Type.ARRAY, false).build();
    private final List<Attribute> attributes;
    private final Map<String, Attribute> attributeMap;

    @JsonCreator
    public Schema(@JsonProperty(value="attributes") List<Attribute> list) {
        if (list == null) {
            throw new IllegalArgumentException("'attributes' must be present");
        }
        this.attributes = Collections.unmodifiableList(list);
        LinkedHashMap<String, Attribute> linkedHashMap = new LinkedHashMap<String, Attribute>();
        for (Attribute attribute : list) {
            linkedHashMap.put(attribute.getName(), attribute);
        }
        this.attributeMap = Collections.unmodifiableMap(linkedHashMap);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @JsonIgnore
    public Attribute getAttribute(String string) {
        return this.attributeMap.get(string);
    }

    public static class Builder {
        private List<Attribute> attributes = new ArrayList<Attribute>();

        public Builder addAttribute(String string, Attribute.Type type, boolean bl) {
            this.attributes.add(new Attribute(string, type, null, bl));
            return this;
        }

        public Builder addAttribute(String string, Attribute.Type type, List<Object> list, boolean bl) {
            this.attributes.add(new Attribute(string, type, list, bl));
            return this;
        }

        public Schema build() {
            return new Schema(this.attributes);
        }
    }
}

