/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema.compact;

import io.kazuki.v0.internal.v2schema.Attribute;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.internal.v2schema.Transform;
import io.kazuki.v0.internal.v2schema.types.TypeTransforms;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.crypto.dsig.TransformException;

public class FieldTransform
implements Transform<Map<String, Object>, Map<String, Object>> {
    private final Schema schema;
    private final Map<String, Transform<?, ?>> fieldCompactions;

    public FieldTransform(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema definition must not be null");
        }
        this.schema = schema;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Attribute attribute : schema.getAttributes()) {
            linkedHashMap.put(attribute.getName(), TypeTransforms.validatorFor(attribute));
        }
        this.fieldCompactions = Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<String, Object> pack(Map<String, Object> map) throws TransformException {
        Object object;
        if (map == null) {
            throw new TransformException("instance must not be null");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry<String, Transform<?, ?>> object2 : this.fieldCompactions.entrySet()) {
            String string = object2.getKey();
            object = object2.getValue();
            Attribute attribute = this.schema.getAttribute(string);
            Object object3 = map.get(string);
            if (object3 == null) {
                if (attribute.isNullable()) {
                    linkedHashMap.put(string, null);
                    continue;
                }
                throw new TransformException("attribute must not be null: " + string);
            }
            try {
                Object u = object.pack(object3);
                linkedHashMap.put(string, u);
            }
            catch (ClassCastException classCastException) {
                throw new TransformException("invalid attribute value for '" + string + "'");
            }
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            object = entry.getKey();
            if (linkedHashMap.containsKey(object)) {
                linkedHashMap2.put(object, linkedHashMap.get(object));
                continue;
            }
            linkedHashMap2.put(object, map.get(object));
        }
        return linkedHashMap2;
    }

    @Override
    public Map<String, Object> unpack(Map<String, Object> map) throws TransformException {
        if (map == null) {
            throw new TransformException("instance must not be null");
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Attribute attribute = this.schema.getAttribute(string);
            if (attribute == null) {
                linkedHashMap.put(string, entry.getValue());
                continue;
            }
            Object object = entry.getValue();
            if (object == null) {
                if (attribute.isNullable()) {
                    linkedHashMap.put(string, null);
                    continue;
                }
                throw new TransformException("attribute must not be null: " + string);
            }
            Transform<?, ?> transform = this.fieldCompactions.get(string);
            Object obj = transform.unpack(object);
            linkedHashMap.put(string, obj);
        }
        return linkedHashMap;
    }

    public Object transformValue(String string, Object object) throws TransformException {
        try {
            Transform<?, ?> transform = this.fieldCompactions.get(string);
            return transform != null ? transform.unpack(object) : object;
        }
        catch (ClassCastException classCastException) {
            throw new TransformException("invalid attribute value for '" + string + "'");
        }
    }
}

