/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema.types;

import io.kazuki.v0.internal.v2schema.Transform;
import io.kazuki.v0.internal.v2schema.types.TransformException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EnumTransform
implements Transform<Object, Integer> {
    private final Map<String, Integer> toMapping;
    private final List<String> values;

    public EnumTransform(List<String> list) {
        int n = 0;
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            linkedHashMap.put(string, n);
            arrayList.add(string);
            ++n;
        }
        this.toMapping = Collections.unmodifiableMap(linkedHashMap);
        this.values = Collections.unmodifiableList(arrayList);
    }

    @Override
    public Integer pack(Object object) throws TransformException {
        if (object == null) {
            throw new TransformException("must not be null");
        }
        String string = object.toString();
        if (!this.toMapping.containsKey(string)) {
            throw new TransformException("is not a valid enum value : " + string);
        }
        return this.toMapping.get(string);
    }

    @Override
    public Object unpack(Integer n) throws TransformException {
        if (n == null) {
            throw new TransformException("must not be null");
        }
        if (n < 0) {
            throw new TransformException("must be greater than or equal to zero");
        }
        if (n >= this.values.size()) {
            throw new TransformException("value not found : " + n);
        }
        return this.values.get(n);
    }
}

