/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema.types;

import io.kazuki.v0.internal.v2schema.Transform;
import io.kazuki.v0.internal.v2schema.types.TransformException;
import java.math.BigInteger;

public class IntegerTransform
implements Transform<Object, Number> {
    private final BigInteger min;
    private final BigInteger max;

    public IntegerTransform(String string, String string2) {
        this.min = new BigInteger(string);
        this.max = new BigInteger(string2);
    }

    @Override
    public BigInteger pack(Object object) throws TransformException {
        if (object == null) {
            throw new TransformException("must not be null");
        }
        try {
            String string = object.toString();
            BigInteger bigInteger = new BigInteger(string);
            if (bigInteger.compareTo(this.min) < 0) {
                throw new TransformException("must be greater than or equal to " + this.min);
            }
            if (bigInteger.compareTo(this.max) > 0) {
                throw new TransformException("must be less than or equal to " + this.max);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TransformException("is not a valid integer");
        }
    }

    @Override
    public Object unpack(Number number) throws TransformException {
        if (number == null) {
            throw new TransformException("must not be null");
        }
        BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : new BigInteger(number.toString());
        Number number2 = number;
        int n = bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE));
        int n2 = bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE));
        if (n >= 0 && n2 <= 0) {
            number2 = number.longValue();
        }
        return number2;
    }
}

