/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema.types;

import io.kazuki.v0.internal.v2schema.Attribute;
import io.kazuki.v0.internal.v2schema.Transform;
import io.kazuki.v0.internal.v2schema.types.AnyTransform;
import io.kazuki.v0.internal.v2schema.types.ArrayTransform;
import io.kazuki.v0.internal.v2schema.types.BooleanTransform;
import io.kazuki.v0.internal.v2schema.types.EnumTransform;
import io.kazuki.v0.internal.v2schema.types.IntegerTransform;
import io.kazuki.v0.internal.v2schema.types.MapTransform;
import io.kazuki.v0.internal.v2schema.types.SmallStringTransform;
import io.kazuki.v0.internal.v2schema.types.TextTransform;
import io.kazuki.v0.internal.v2schema.types.UTCDateTransform;

public class TypeTransforms {
    public static Transform<?, ?> validatorFor(Attribute attribute) {
        switch (attribute.getType()) {
            case ANY: {
                return new AnyTransform();
            }
            case MAP: {
                return new MapTransform();
            }
            case ARRAY: {
                return new ArrayTransform();
            }
            case BOOLEAN: {
                return new BooleanTransform();
            }
            case ENUM: {
                return new EnumTransform(attribute.getValues());
            }
            case U8: {
                return new IntegerTransform("0", Integer.toString(255));
            }
            case U16: {
                return new IntegerTransform("0", Integer.toString(65535));
            }
            case U32: {
                return new IntegerTransform("0", Long.toString(0xFFFFFFFFL));
            }
            case U64: {
                return new IntegerTransform("0", Long.toString(Long.MAX_VALUE));
            }
            case I8: {
                return new IntegerTransform(Integer.toString(-128), Integer.toString(127));
            }
            case I16: {
                return new IntegerTransform(Integer.toString(Short.MIN_VALUE), Integer.toString(Short.MAX_VALUE));
            }
            case I32: {
                return new IntegerTransform(Integer.toString(Integer.MIN_VALUE), Integer.toString(Integer.MAX_VALUE));
            }
            case I64: {
                return new IntegerTransform(Long.toString(Long.MIN_VALUE), Long.toString(Long.MAX_VALUE));
            }
            case UTC_DATE_SECS: {
                return new UTCDateTransform();
            }
            case UTF8_SMALLSTRING: {
                return new SmallStringTransform();
            }
            case UTF8_TEXT: {
                return new TextTransform();
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)attribute.getType()));
    }
}

