/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.jdbi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.kazuki.v0.store.config.ConfigurationBuilder;

public class JdbiDataSourceConfiguration {
    private final String jdbcDriver;
    private final String jdbcUrl;
    private final String jdbcUser;
    private final String jdbcPassword;
    private final int poolMinConnections;
    private final int poolMaxConnections;

    public JdbiDataSourceConfiguration(@JsonProperty(value="jdbcDriver") String string, @JsonProperty(value="jdbcUrl") String string2, @JsonProperty(value="jdbcUser") String string3, @JsonProperty(value="jdbcPassword") String string4, @JsonProperty(value="poolMinConnections") int n, @JsonProperty(value="poolMaxConnections") int n2) {
        Preconditions.checkNotNull((Object)string, (Object)"jdbcDriver");
        Preconditions.checkNotNull((Object)string2, (Object)"jdbcUrl");
        Preconditions.checkNotNull((Object)string3, (Object)"jdbcUser");
        Preconditions.checkNotNull((Object)string4, (Object)"jdbcPassword");
        this.jdbcDriver = string;
        this.jdbcUrl = string2;
        this.jdbcUser = string3;
        this.jdbcPassword = string4;
        this.poolMinConnections = n;
        this.poolMaxConnections = n2;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public int getPoolMinConnections() {
        return this.poolMinConnections;
    }

    public int getPoolMaxConnections() {
        return this.poolMaxConnections;
    }

    public static class Builder
    implements ConfigurationBuilder<JdbiDataSourceConfiguration> {
        private String jdbcDriver;
        private String jdbcUrl;
        private String jdbcUser;
        private String jdbcPassword;
        private int poolMinConnections;
        private int poolMaxConnections;

        public Builder withJdbcDriver(String string) {
            this.jdbcDriver = string;
            return this;
        }

        public Builder withJdbcUrl(String string) {
            this.jdbcUrl = string;
            return this;
        }

        public Builder withJdbcUser(String string) {
            this.jdbcUser = string;
            return this;
        }

        public Builder withJdbcPassword(String string) {
            this.jdbcPassword = string;
            return this;
        }

        public Builder withPoolMinConnections(int n) {
            this.poolMinConnections = n;
            return this;
        }

        public Builder withPoolMaxConnections(int n) {
            this.poolMaxConnections = n;
            return this;
        }

        @Override
        public JdbiDataSourceConfiguration build() {
            return new JdbiDataSourceConfiguration(this.jdbcDriver, this.jdbcUrl, this.jdbcUser, this.jdbcPassword, this.poolMinConnections, this.poolMaxConnections);
        }
    }
}

